from flask import Flask, request
from transformers import AutoModelForImageClassification
from transformers import AutoImageProcessor
from PIL import Image
from io import BytesIO
import os
import torch

app = Flask(__name__)

model = AutoModelForImageClassification.from_pretrained(
    './my_model')
image_processor = AutoImageProcessor.from_pretrained(
    "microsoft/resnet-50")


@app.route('/upload_image', methods=['POST'])
def upload_image():
    # Get the image file from the request
    image_file = request.files['image'].stream
    
    # image = Image.open(BytesIO(image_file.read()))
    image = Image.open(image_file)
    inputs = image_processor(image, return_tensors="pt")
    
    with torch.no_grad():
        logits = model(**inputs).logits

    predicted_label = logits.argmax(-1).item()

    disease = model.config.id2label[predicted_label]
    

    # You can perform additional operations with the image here
    # ...

    return disease
    


@app.route('/', methods=['GET'])
def hi():
    return "NAPTAH Mobile Application"




app.run(host='0.0.0.0', port=7860)