import numpy as np
import matplotlib.pyplot as plt

# Natural MOS to AVA MOS

def linear_function(x):
    m = (4 - 1) / (1.5 - 1)  
    b = 1 - m * 1  
    return m * x + b

def quadratic_function(x):
    return -0.0816 * (x - 5) ** 2 + 5

# Natural MOS to AVA MOS
def nat2avaMOS(x):
    if x <= 1.5:
        return linear_function(x)
    elif x >1.5 and x <= 5:
        return quadratic_function(x)

# Word error rate to Intellibility Score (X is percentage)
def WER2INTELI(x):
    if x <= 10:
        return 100
    elif x <= 100:
        slope = (30 - 100) / (100 - 10)
        intercept = 100 - slope * 10
        return slope * x + intercept
    else:
        return 100 * np.exp(-0.01 * (x - 100))

# 生成 x 值
# x = np.linspace(0, 200, 400)  # 从0到200生成400个点

# 计算对应的 y 值
# y = [WER2INTELI(xi) for xi in x]


# plt.plot(x, y)
# plt.xlabel('x')
# plt.ylabel('f(x)')
# plt.title('Custom Function')
# plt.grid(True)
# plt.show()

# 生成 x 值的范围
x1 = np.linspace(1, 1.5, 100)
x2 = np.linspace(1.5, 5, 100)

# 计算对应的 y 值
y1 = linear_function(x1)
y2 = quadratic_function(x2)

# 绘制线性部分
plt.plot(x1, y1, label='Linear Function (1 <= x <= 1.5)')

# 绘制二次部分
plt.plot(x2, y2, label='Quadratic Function (1.5 <= x <= 5)')

# 添加标签和标题
plt.xlabel('Natural Mean Opinion Score')
plt.ylabel('AVA Mean Opinion Score')
plt.title('nat2avaMOS')

# 添加图例
plt.legend()

# 显示图形
plt.grid(True)

# 显示图像
plt.savefig("./local/nat2avaMOS.png")
# plt.savefig("./local/WER2INT.png")