import os
os.system('pip install gradio==2.3.0a0')
os.system('pip install voicefixer --upgrade')
from voicefixer import VoiceFixer
import gradio as gr
voicefixer = VoiceFixer()
def inference(audio,mode):
    voicefixer.restore(input=audio.name, # input wav file path
                    output="output.wav", # output wav file path
                    cuda=False, # whether to use gpu acceleration
                    mode = int(mode)) # You can try out mode 0, 1 to find out the best result
    return 'output.wav'

inputs = [gr.inputs.Audio(type="file", label="Input Audio"),gr.inputs.Radio(choices=['0','1','2'], type="value", default='0', label='mode')]
outputs =  gr.outputs.Audio(type="file",label="Output Audio")


title = "Voice Fixer"
description = "Gradio demo for VoiceFixer: Toward General Speech Restoration With Neural Vocoder. To use it, simply add your audio, or click one of the examples to load them. Read more at the links below."
article = "<p style='text-align: center'><a href='https://arxiv.org/abs/2109.13731' target='_blank'>VoiceFixer: Toward General Speech Restoration With Neural Vocoder</a> | <a href='https://github.com/haoheliu/voicefixer_main' target='_blank'>Github Repo</a></p>"

examples=[['bruce.wav','2']]

gr.Interface(inference, inputs, outputs, title=title, description=description, article=article, examples=examples, enable_queue=True).launch()
