import torch
import torchaudio
from speechbrain.pretrained import SpectralMaskEnhancement
import gradio as gr

enhance_model = SpectralMaskEnhancement.from_hparams(
    source="speechbrain/metricgan-plus-voicebank",
    savedir="pretrained_models/metricgan-plus-voicebank",
)

def speechbrain(aud):
  # Load and add fake batch dimension
  noisy = enhance_model.load_audio(
      aud
  ).unsqueeze(0)
  enhanced = enhance_model.enhance_batch(noisy, lengths=torch.tensor([1.]))
  torchaudio.save('enhanced.wav', enhanced.cpu(), 16000)
  return 'enhanced.wav'
  
inputs = gr.Audio(label="Input Audio", type="filepath")
outputs = gr.Audio(label="Output Audio", type="filepath")
title = "Speechbrain Speech Enhancement"
description = "Gradio demo for Speech enhancement with SpeechBrain. To use it, simply upload your audio, or click one of the examples to load them. Read more at the links below."
article = "<p style='text-align: center'><a href='https://arxiv.org/abs/2104.03538' target='_blank'>MetricGAN+: An Improved Version of MetricGAN for Speech Enhancement</a> | <a href='https://github.com/speechbrain/speechbrain' target='_blank'>Github Repo</a></p>"
examples = [
    ['samples_audio_samples_example_fr.wav']
]
gr.Interface(speechbrain, inputs, outputs, title=title, description=description, article=article, examples=examples).launch()