import { defineConfig } from 'vite'
import glsl from 'vite-plugin-glsl'

export default defineConfig(({ command, mode }) => {
  return {
    resolve: {
      alias: {
        babylonjs: mode === 'development' ? 'babylonjs/babylon.max' : 'babylonjs',
      },
    },
    build: {
      rollupOptions: {
        output: [{
          manualChunks: (id) => {
            if (id.includes('@babylonjs/core'))
              return 'babylonjs-core'
            else if (id.includes('@babylonjs/gui'))
              return 'babylonjs-gui'
            else if (id.includes('@babylonjs/loaders/glTF'))
              return 'babylonjs-loaders-glTF'
          },
        }],
      },
    },
    plugins: [glsl()],
    server: {
      port: 3000,
    },
  }
})
