export interface TimingOptions {
  duration: number
  delay?: number
  iterations?: number
  easing?: (p: number) => number
}

export class Timing {
  delay: number
  duration: number
  iterations: number
  startTime: number
  easing: (p: number) => number

  private _isDisposed = false

  constructor(opts: TimingOptions) {
    const { duration, delay = 0, iterations = 1, easing = p => p } = opts
    this.startTime = Date.now()
    this.delay = delay
    this.duration = duration
    this.iterations = iterations
    this.easing = easing
  }

  get time() {
    return Date.now() - this.startTime
  }

  get p() {
    const progress = Math.min(this.time / this.duration, this.iterations)
    return this.isFinished ? 1 : this.easing(progress % 1)
  }

  get isPaused() {
    return this.time < this.delay
  }

  get isFinished() {
    return this.time / this.duration >= this.iterations
  }

  get isDispose() {
    return this._isDisposed
  }

  dispose() {
    this._isDisposed = true
  }
}
