import { rest } from 'msw'
import { API_BASE_URL } from '../../src/constants'
import detectionResult from './detection-result.json'
import classificationResult from './classification-result.json'
import MOCK_IMAGE_URL from './mock_image.jpg'

const handlers = [
  rest.post(`${API_BASE_URL}detect-image`, (req, res, ctx) => {
    return res(ctx.status(200), ctx.json(detectionResult))
  }),
  rest.post(`${API_BASE_URL}classify-image`, (req, res, ctx) => {
    return res(ctx.status(200), ctx.json(classificationResult))
  }),
  rest.post(`${API_BASE_URL}text-to-image`, async (req, res, ctx) => {
    const image = await ctx.fetch(MOCK_IMAGE_URL)
    return res(ctx.status(200), ctx.body(await image.arrayBuffer()))
  }),
]

export default handlers
