from fastai.vision.all import *
import gradio as gr
import skimage

# Function needed to set labels
def is_cat(filename):
    return filename.name[0].isupper() 

learn = load_learner('cat_dog_model.pkl')
labels = learn.dls.vocab

def predict(img):
    img = PILImage.create(img)
    pred, pred_idx, probs = learn.predict(img)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}


title = "Cat/Dog Classifier"
description = "Basic Cat/Dog classifier trained on the Oxford Pets dataset with fastai. Testing out Gradio on HF Spaces."
examples = ['siamese.jpg', 'boerboel.jpg', 'german_shepherd.jpg', 'sphynx.jpg']
enable_queue=True

gr.Interface(
    fn=predict, 
    inputs=gr.Image(shape=(512,512)),
    outputs=gr.Label(num_top_classes=3),
    title=title,
    description=description,
    examples=examples,
).launch(enable_queue=enable_queue)


