from langchain.memory import ConversationSummaryBufferMemory
from langchain.chains import ConversationChain
from langchain.chains import RetrievalQA
from utils.API import Spark_forlangchain
import gradio as gr
from langchain.prompts import ChatPromptTemplate
from langchain.document_loaders import TextLoader
from langchain.embeddings.huggingface import HuggingFaceEmbeddings
from langchain.vectorstores import FAISS
import sentence_transformers


def init_knowledge_vector_store(filepath):
    EMBEDDING_MODEL = "model/text2vec_ernie/"
    embeddings = HuggingFaceEmbeddings(model_name=EMBEDDING_MODEL)
    embeddings.client = sentence_transformers.SentenceTransformer(
        embeddings.model_name, device='cuda')
    loader = TextLoader(filepath)
    docs = loader.load()
    vector_store = FAISS.from_documents(docs, embeddings)
    return vector_store


template_1 = """
你是一个资深辩手，你的辩论风格是{style}，你确定辩论战略需要考虑以下10个方面:
1. 分析辩题性质
判断辩题是判断型还是比较型,明确需要论证的核心观点。回答中必须包含题是判断型还是比较型。
2. 判断正反方定位
大致判断哪一方更容易证成立,存在明显优劣势。回答中必须需给出谁更主流，更容易成立。
3. 设想核心争议点
思考双方可能存在分歧和交锋的主要争议点。回答中需要明确给出至少三个争议点。
4. 论证框架
设计初步的论证框架,包括定义、标准、论点等。回答中需要明确按以下格式给出论证框架：正方：标准是XXX，论点1是XXX，论点2是XXX。反方：标准是XXX，论点1是XXX，论点2是XXX。（论点至少要两个）
5. 优势论域
确定自己方更容易取得优势的论域的诠释点。回答中必须详细给出双方的优势论域并给出理由。
6. 数据准备
提前准备论证所需的证据数据。回答中必须给出对论证起作用的数据，如相关国家合法化情况与对社会影响的数据
7. 情境假设
设想场景和例子以备交锋时使用。回答中必须至少给出正反双方情境，各三个。
8. 语境处理
考虑如何处理语境环境,为自己创造有利条件。回答中必须举出正反方的语境，各三个。
9. 质询角度
提前想好可能的质询角度,对应对方的论点。回答中需要给出详细的分析并试着举出例子，各三个。
10. 重点突破
找到对方可能论证的薄弱点,准备重点突破。回答中需要举出正反双方薄弱点分别在哪里，应该如何突破。
通过上述分析,可以确定一个明确有针对性的辩论战略.
接下来我会给你一个具体的辩题，你需要基于以上10个原则依次回答。
///辩题内容如下：{text}///
"""
template_2 = """
你是一个资深辩手，你的辩论风格是{style}，你立论会遵循以下的立论原则，总共5个原则:
1.定义明确
对关键词进行明确且合理的定义,这是展开论证的基础。
2.标准清晰
设置公正合理的判断标准,标准要具体明确,为论点比较提供依据。你的回答中必须包含标准。
3.论点匹配
论点要能有效支撑并印证标准,与标准和立场高度契合。你的回答中必须包含支撑印证标准的论点。
4.论据具体
提供具体可信的论据支撑每个论点,使之更有说服力。你的论点必须要论据支撑。
5.情境适用
引入情境和例子,使复杂观点容易被听众接受。你的回答可以适当包含情境
接下来会给你一个题目和持方。
///题目与持方如下：{text}///
你需要遵循以上五个立论原则立论，并且立论稿有以下要求：
1.以一个专业辩手的口吻做开场白。
2.总字数为1200字。
3.第一段需要包含以下三个部分 给出持方，对名词做出简单解释，给出标准，标准只能有一个。
4.第二段是第一个论点，论点需要围绕标准，阐述完论点后需要提出论据，最好是数据论据和学理论据，提出论据后需要做出解释来进行论证。参照以下流程：论点1+数据论据+数据论据的论证+学理论据+学理论据的论证。本段需要非常详细。
5.第三段是第二个论点，论点需要围绕标准，本段第一句话就要阐明论点是什么，阐述完论点后需要提出论据，最好是数据论据和学理论据，提出论据后需要做出解释来进行论证。参照以下流程：论点2+数据论据+数据论据的论证+学理论据+学理论据的论证。本段需要非常详细。
6.最后一段只需要用一句话再重复一遍己方的立场：“综上我方坚定认为XXX”。XXX为立场。
7.立论稿中需要把上述内容衔接流畅。
"""
template_3 = """
你是一个资深的逻辑性很强的顶级辩手，你的辩论风格是{style}，请对我的陈述进行反驳，越详细越好，反驳需要逐条反驳观点和论据，并且要给出详细的理由，质疑数据论据要用上常用的方法和句式，从数据合理性，样本代表性，统计方法，数据解读等多个角度进行考虑。质疑学理论据要从权威性，解读方式，是否有对抗学理等多个角度进行考虑。
///如下是我们的话题以及我的观点：{text}///
"""
template_4 = """
你是一个资深辩手，你的辩论风格是{style}，你需要根据我给出的话题提出观点并且要有数据论据和学理论据作为论证且总字数不少于400字，你的发言格式为：我们的话题是什么，我持什么观点，我的理由是XXX，因为某某数据，又因为某某学理。参照如下范例：||
我们的话题是人工智能对人类工作的影响。我持的观点是，人工智能将导致大量的就业机会减少。我的理由是，根据国际数据公司(IDC)的报告，到2025年，全球约有3.75亿个工作岗位将被自动化技术取代。同时，人工智能的发展也将带来新的就业机会，如AI工程师、数据科学家等。
首先，让我们从数据角度来看。根据美国劳工统计局(BLS)的数据，自20世纪90年代以来，美国的工作岗位流失率一直在上升。其中，自动化和计算机化在一定程度上对就业市场产生了负面影响。此外，根据麦肯锡全球研究院的预测，到2030年，人工智能可能会在全球范围内导致8000万至1.6亿个工作岗位的消失。
其次，从学理角度来看，人工智能的发展是基于算法和大数据的。然而，这些算法和数据往往受到人为因素的影响，可能导致错误的决策和预测。例如，2016年在美国总统选举期间，一家名为“剑桥分析”的公司利用大数据分析和选民心理研究，为特朗普竞选团队提供了策略支持。这一事件表明，人工智能在某些情况下可能会被用于不道德的目的。||
///我们本次讨论的话题是{text}///
"""
template_5 = """
你是一个资深的逻辑性很强的顶级辩手，你的辩论风格是{style}，可以与我进行辩论训练，你很擅长质询总是一针见血，而且也很擅长使用类比来归谬我的观点，你熟练的掌握各种数据质询的技巧。现在你要与我进行对辩
我的陈述如下：///{text}///
请对我的陈述进行反驳，越详细越好，反驳需要逐条反驳观点和论据，并且要给出详细的理由，质疑数据论据要用上常用的方法和句式，从数据合理性，样本代表性，统计方法，数据解读等多个角度进行考虑。质疑学理论据要从权威性，解读方式，是否有对抗学理等多个角度进行考虑。
"""
end_prompt = """
请你对我们的对辩过程进行总结，总结需要包括以下部分：1.对辩主要针对什么进行讨论。2.评价我的对辩能力，需要根据评级原则给出评级，并且给出具体理由。评级原则如下：等级一，缺乏论证的反驳；等级二，自说自话的反驳；等级三，针锋相对的反驳；等级四，正中要害的反驳。3.根据我的对辩能力提出一定的建议。
示例如下：
好的，我来对我们的对辩过程进行总结。
在我们的对辩过程中，我们主要讨论了动物园是否应该被禁止。我认为动物园对动物的福利和权利造成了负面影响，而您则提出了一些质疑，认为动物园中的动物可以享受比野外更安全的生活条件。
我认为您的对辩能力属于等级三，即针锋相对的反驳。您能够对我的观点提出一些质疑和反驳，并且能够给出一些合理的理由。但是，在某些情况下，您可能会使用一些不太恰当的类比来归谬我的观点，这可能会影响到对辩的质量和效果。
鉴于您的对辩能力，我认为您可以进一步提高自己的辩论技巧。您可以通过更多的阅读和学习，提高自己的知识水平和思维能力，从而更好地进行论证和反驳。此外，在使用类比和比喻时，需要更加谨慎，确保它们能够恰当地表达您的观点，而不会歪曲或归谬对方的观点。
"""
prompt_1 = ChatPromptTemplate.from_template(template_1)
prompt_2 = ChatPromptTemplate.from_template(template_2)
prompt_3 = ChatPromptTemplate.from_template(template_3)
prompt_4 = ChatPromptTemplate.from_template(template_4)
prompt_5 = ChatPromptTemplate.from_template(template_5)


def init_(app_id, api_key, api_secret):
    global llm
    llm = Spark_forlangchain(n=10, app_id=app_id, api_key=api_key,
                             api_secret=api_secret)
    memory = ConversationSummaryBufferMemory(llm=llm, max_token_limit=4096)
    global conversation_1
    global conversation_2
    global conversation_3
    conversation_1 = ConversationChain(llm=llm)
    conversation_2 = ConversationChain(llm=llm, memory=memory)
    print("初始化成功！")


def shortDebate_(type, style, prompt, help):
    if type == "破题":
        msg = prompt_1.format_prompt(text=prompt, style=style).to_string()
    elif type == "立论":
        msg = prompt_2.format_prompt(text=prompt, style=style).to_string()
    elif type == "对辩先发":
        msg = prompt_3.format_prompt(text=prompt, style=style).to_string()
    elif type == "对辩后发":
        msg = prompt_4.format_prompt(text=prompt, style=style).to_string()
    else:
        msg = prompt
    print(msg)
    response = conversation_1.run(msg)
    print(response)
    help.append((prompt, response))
    return help, help


def longDebate_(style, prompt, help):
    msg = prompt_5.format_prompt(text=prompt, style=style).to_string()
    response = conversation_2.run(msg)
    help.append((prompt, response))
    return help, help


def end_talk(style, prompt, help):
    msg = end_prompt
    response = conversation_2.run(msg)
    help.append((prompt, response))
    return help, help


def Debatebytext_(prompt, help):
    msg = prompt
    response = QA_chain.run(msg)
    help.append((prompt, response))
    return help, help


def upload_file(files):
    vector_store = init_knowledge_vector_store(files.name)
    memory_text = ConversationSummaryBufferMemory(
        llm=llm, max_token_limit=4096)
    global QA_chain
    QA_chain = RetrievalQA.from_llm(llm=llm, retriever=vector_store.as_retriever(
        search_kwargs={"k": 2}), memory=memory_text)
    file_paths = [file.name for file in files]
    return file_paths


with gr.Blocks(css="#chatbot{height:300px} .overflow-y-auto{height:500px}") as init:
    with gr.Row():
        app_id = gr.Textbox(
            lines=1, placeholder="app_id Here...", label="app_id")
        api_key = gr.Textbox(
            lines=1, placeholder="api_key Here...", label="api_key")
        api_secret = gr.Textbox(
            lines=1, placeholder="api_secret Here...", label="api_secret")
        temperature = gr.Slider(minimum=0, maximum=1,
                                step=0.1, value=0.3, interactive=True)
        btn = gr.Button(value="初始化")
        btn.click(init_, inputs=[app_id, api_key, api_secret])

with gr.Blocks(css="#chatbot{height:300px} .overflow-y-auto{height:500px}") as shortDebate:
    chatbot = gr.Chatbot(elem_id="chatbot")
    state = gr.State([])
    drop1 = gr.Radio(["破题", "立论", "对辩先发", "对辩后发"],
                     label="功能选择", info="选择你想要的功能")  # 单选
    with gr.Row():
        txt = gr.Textbox(show_label="在这里开始聊天吧", placeholder="请输入你的问题")
        send = gr.Button("🚀 发送")
    style = gr.Textbox(lines=1, placeholder="style Here... ",
                       label="辩论风格", value="犀利", interactive=True)
    send.click(shortDebate_, [drop1, style, txt, state], [chatbot, state])

with gr.Blocks(css="#chatbot{height:300px} .overflow-y-auto{height:500px}") as longDebate:
    chatbot = gr.Chatbot(elem_id="chatbot")
    state = gr.State([])
    with gr.Row():
        txt = gr.Textbox(show_label="在这里开始长辩论吧", placeholder="请输入你的问题")
        send = gr.Button("🚀 发送")
        end = gr.Button("🤠 总结")
    style = gr.Textbox(lines=1, placeholder="style Here... ",
                       label="辩论风格", value="犀利", interactive=True)
    send.click(longDebate_, [style, txt, state], [chatbot, state])
    end.click(end_talk, [style, txt, state], [chatbot, state])

with gr.Blocks(css="#chatbot{height:300px} .overflow-y-auto{height:500px}") as Debatebytext:
    chatbot = gr.Chatbot(elem_id="chatbot")
    state = gr.State([])
    file_output = gr.File(label='请上传文件, 目前支持txt、docx、md格式',
                          file_types=['.txt', '.md', '.docx'])
    with gr.Row():
        txt = gr.Textbox(show_label="在这里从你给出的资料里学习吧", placeholder="请输入你的问题")
        send = gr.Button("🚀 发送")
    upload_button = gr.UploadButton("Click to Upload a File", scale=1, file_types=[
                                    "text"])
    upload_button.upload(upload_file, upload_button, file_output)
    send.click(Debatebytext_, [txt, state], [chatbot, state])
demo = gr.TabbedInterface([init, shortDebate, longDebate, Debatebytext], [
                          "初始化", "辅助辩论", "对辩练习", "辩论技巧学习"])
demo.launch()
