# import gradio as gr

# gr.Interface.load("models/KaraAgroAI/CADI-AI").launch()

import gradio as gr
# import cv2
# import requests
# import os
from PIL import Image
import torch
import ultralytics

model = torch.hub.load("ultralytics/yolov5", "custom", path="model/yolov5_0.65map_exp7_best.pt",
                        force_reload=False) 

model.conf = 0.20  # NMS confidence threshold

# sample test images
path  = [['sample-test-images/231.jpg'], ['sample-test-images/82.jpg'], ['sample-test-images/91.jpg']]

def show_preds_image(im):

    results = model(im)  # inference
    return results.render()[0]

inputs_image = [
    gr.components.Image(type="filepath", label="Input Image"),
]
outputs_image = [
    gr.components.Image(type="filepath", label="Output Image"),
]
interface_image = gr.Interface(
    fn=show_preds_image,
    inputs=inputs_image,
    outputs=outputs_image,
    title="Cashew Disease Identification with AI",
    examples=path,
    cache_examples=False,
)

interface_image.launch()