import streamlit as st
import os
col1, col2 = st.columns(2)
col1.title('DIFF-SVC Render')
col2.title('Settings')
ckpt = col1.file_uploader("Choose your CKPT", type='ckpt')
config = col1.file_uploader("Choose your config", type='yaml')
audio = col1.file_uploader("Choose your audio", type=["wav"])
title = col2.number_input("Key", value=0, step=1, min_value=-12, max_value=12)
title2 = col2.number_input("Speedup", value=20, step=1, min_value=5, max_value=100)
title3 = col2.number_input("Gender Flag", value=1.00, step=0.01, min_value=0.70, max_value=1.30, help='Default is 1.0, it works by decimals, setting it at 1.05 will make your render sound more female-ish, setting it to 0.95 will make it sound more masculine, for example.')
choice = col2.selectbox('Resampler', ('Crepe', 'Harvest'))
# Create checkbox for using Mel as Base
use_mel_as_base = col2.checkbox('Use Mel as Base', value=False, help='gt mel: Enabling this will use the input audio as a base and will unlock a new parameter, do not use this if you dont know what it does.')
# Show "Noise Step" input parameter when checkbox is checked
if use_mel_as_base:
    noise_step = col2.number_input('Noise Step', value=600, min_value=1, max_value=1000, step=50)
else:
    noise_step = None
password = col2.text_input("Enter password", help='Password can be got by agreeing to TOS and getting allowed after validation, you can go to the TOS here:')
# Rest of the code
