import tempfile ,os
import gradio as gr

MAX_TXT_LEN = 800
def tts(text: str):
    if len(text) > MAX_TXT_LEN:
        text = text[:MAX_TXT_LEN]
        print(f"Input text was cutoff since it went over the {MAX_TXT_LEN} character limit.")
    print(text)
    import subprocess
    
    with tempfile.NamedTemporaryFile(suffix=".wav", delete=False) as fp:
        #print(fp)
        output = subprocess.check_output(f'mimic3 --voice fa/haaniye_low "{text}" > {fp.name}', shell=True, stderr=subprocess.STDOUT)
        return fp.name



article= ""
examples=[
    ["شیش سیخ جیگر سیخی شیش هزار"],
    ["سه شیشه شیر ، سه سیر سرشیر"],
    ["دزدی دزدید ز بز دزدی بزی ، عجب دزدی که دزدید ز بز دزدی بزی"],
    ["مثنوی یکی از قالب های شعری است ک هر بیت قافیه ی جداگانه دارد"],
    ["در گلو ماند خس او سالها، چیست آن خس مهر جاه و مالها"],
]
iface = gr.Interface(
    fn=tts,
    inputs=[
        gr.Textbox(
            label="Text",
            value="زندگی فقط یک بار است؛ از آن به خوبی استفاده کن",
        )
    ],
    outputs=gr.Audio(label="Output",type='filepath'),
    examples=examples
)
iface.launch(share=False)