import gradio as gr
from transformers import pipeline

examples = ["examples/example_0.jpg", 
            "examples/example_1.jpg", 
            "examples/example_2.jpg", 
            "examples/example_3.jpg", 
            "examples/example_4.jpg",
            "examples/example_5.jpg",
            "examples/example_6.jpg",
            "examples/example_7.jpg"]

pipe = pipeline(task="image-classification", 
                model="Kaludi/food-category-classification-v2.0")
gr.Interface.from_pipeline(pipe, 
                           title="Food Category Classification App",
                           description = "This is a Food Category Image Classifier model that has been trained by <strong><a href='https://huggingface.co/Kaludi'>Kaludi</a></strong> to recognize <strong>12</strong> different categories of foods, which includes <strong>Bread</strong>, <strong>Dairy</strong>, <strong>Dessert</strong>, <strong>Egg</strong>, <strong>Fried Food</strong>, <strong>Fruit</strong>, <strong>Meat</strong>, <strong>Noodles</strong>, <strong>Rice</strong>, <strong>Seafood</strong>, <strong>Soup</strong>, and <strong>Vegetable</strong>. It can accurately classify an image of food into one of these categories by analyzing its visual features. This model can be used by food bloggers, restaurants, and recipe websites to quickly categorize and sort their food images, making it easier to manage their content and provide a better user experience.",
                           article = "<p style='text-align: center'><a href='https://github.com/Kaludii'>Github</a> | <a href='https://huggingface.co/Kaludi'>HuggingFace</a></p>",
                           examples=examples,
                           ).launch()