from typing import Optional


class ColorPalette:
    """Color Palette Container."""
    all = []

    def __init__(
        self,
        c50: str,
        c100: str,
        c200: str,
        c300: str,
        c400: str,
        c500: str,
        c600: str,
        c700: str,
        c800: str,
        c900: str,
        c950: str,
        name: Optional[str] = None,
    ):
        self.c50 = c50
        self.c100 = c100
        self.c200 = c200
        self.c300 = c300
        self.c400 = c400
        self.c500 = c500
        self.c600 = c600
        self.c700 = c700
        self.c800 = c800
        self.c900 = c900
        self.c950 = c950
        self.name = name
        ColorPalette.all.append(self)


KALBE_THEME_COLOR = ColorPalette(
    name='kalbe',
    c50='#f2f9e8',
    c100='#dff3c4',
    c200='#c2e78d',
    c300='#9fd862',
    c400='#7fc93f',
    c500='#3F831C',
    c600='#31661a',
    c700='#244c13',
    c800='#18340c',
    c900='#0c1b06',
    c950='#050a02',
)