import cohere 
import gradio as gr
import requests
from PIL import Image
import io

def generate_text(prompt,maxi,cohere_api_key):
    co = cohere.Client(cohere_api_key)

    response = co.generate(prompt=prompt,
                            temperature=0,
                            max_tokens=maxi)
    return response[0]

def generate_image(prompt,gradio_api_key):
    r = requests.post('https://clipdrop-api.co/text-to-image/v1',
        files={
            'prompt': (None, prompt, 'text/plain')
        },
        headers={'x-api-key': gradio_api_key}
    )

    if r.ok:
        images = Image.open(io.BytesIO(r.content))
        return images
    else:
        raise ValueError("Failed to generate image")
    
def text_and_image_generator(prompt,maxi,cohere_api_key,gradio_api_key):
    cohere_api_key = "jNjJ71MvKxwbLDEz1ABIf5IMRuXvIUDMTx5HEhfP"
    gradio_api_key = "ae9e2d3ac28caa8e845f4a6e33de8018ee109bdea7c3d10135af8797ac1bd8b6a73140a961e346fbb02204aa63aa4f38"
    text = generate_text(f"Generate a story with {prompt}. Conclude the generated story properly.",maxi,cohere_api_key)
    image = generate_image(text,gradio_api_key)
    title = generate_text(f"title for the story {prompt} within 5 words",5,cohere_api_key)

    return title,text,image

app = gr.Interface(
    title="Story and Image Generator",
    fn=text_and_image_generator,
    inputs = [gr.inputs.Textbox(label="Enter your prompt to generate a story"),
    gr.inputs.Slider(420,1000,label="Story length")],
    outputs= [gr.outputs.Textbox(label="Story title"),gr.outputs.Textbox(label="Story"),gr.outputs.Image(type="pil",label="Image based on the Generated story")],theme="dark"
)

app.launch()