import os

import gradio as gr
from paddlespeech.cli import TTSExecutor

tts_executor = TTSExecutor()


def speech_generate(text: str) -> os.PathLike:
    assert isinstance(text, str) and len(text) > 0, 'Input Chinese text...'
    wav_file = tts_executor(text=text)
    return wav_file


iface = gr.Interface(
    fn=speech_generate, 
    inputs=gr.inputs.Textbox(placeholder='请输入文字...'),
    outputs=gr.outputs.Audio(),
)
iface.launch()
