import openai
import os
import gradio as gr

openai.api_key = os.environ.get("OPENAI_API_KEY")

class Conversation:
    def __init__(self, prompt, num_of_round):
        self.prompt = prompt
        self.num_of_round = num_of_round
        self.messages = []
        self.messages.append({"role": "system", "content": self.prompt})

    def ask(self, question):
        try:
            self.messages.append( {"role": "user", "content": question})
            response = openai.ChatCompletion.create(
                model="gpt-3.5-turbo",
                messages=self.messages,
                temperature=0.5,
                max_tokens=512,
                top_p=1,
            )
        except Exception as e:
            print(e)
            return e

        message = response["choices"][0]["message"]["content"]
        self.messages.append({"role": "assistant", "content": message})
        
        if len(self.messages) > self.num_of_round*2 + 1:
            del self.messages[1:3]
        return message
    

prompt = """you are an expert for GER at emory university oxford college, and you are responsible for answering any questions related to it. your answer should be as concise as possible.
here is all the GER requirements for oxford college:
The following information relates to the Blue GER Plan. Students who began their studies at Oxford College in, or after Fall 2023 will follow these requirements.

Note: Only courses with the new GER tags (noted below) satisfy the Blue GER Plan. Courses which retain GER tags from the Gold plan do not count towards completion of the Blue GER Plan. If you have any questions about which courses satisfy your requirements, please contact the Advising Support Center.

Exploration Courses
Exploration courses ensure that students take courses in a variety of fields, across the liberal arts curriculum. These courses are the foundation of the general education experience, giving students experience in a variety of academic areas at the outset of their studies at Emory, and introducing them to different intellectual approaches, tools, and evidence.  Students must complete:

Humanities and Arts [HA] (1 course)
Natural Science [NS] (1 course)
Quantitative Reasoning [QR] (1 course)
Social Science [SS] (1 course)
Timeframe: All courses in the exploration area must be completed by Oxford graduation.

Expression & Communication
Communication-intensive courses are designed to improve communication skills through frequent writing, speaking, listening, and designing across academic and non-academic situations. Teachers across discourse communities encourage, guide, and communicate high standards to students through instruction and example. Communication-intensive classes focus on both the product and the process of developing appropriate and effective communication skills. Learning to be an ethical communicator is a focus of the courses, and instruction (materials, assignments, feedback) is designed to foster this growth in students. Students must complete:

Discovery Seminar [DSC] (1 course)
First Year Writing [FW] (1 course) - may be fulfilled with AP, IB or other appropriate test credit
Continuing Communication [CC] (2 courses*)
Timeframe: The Discovery Seminar and First Year Writing courses must be completed by the end of the first-year. One Continuing Communication course must be completed by Oxford graduation. The second required Continuing Communication course can be taken at Oxford or Atlanta campus.

Belonging & Community
Building Community courses foster connections, relationships, and understanding within and between diverse communities by encouraging students to reflect upon those to which they belong and those with whom they interact on many levels, from local to international settings. During their first three years at Emory, students are required to take one course in these two categories: Race and Ethnicity and Intercultural Communications. Students must complete:

Intercultural Communication [IC] (2 courses in a single language other than English, beginning at a student’s level of fluency) - 1 course may be fulfilled with AP, IB or other appropriate test credit
Race and Ethnicity [ETHN] (1 course)
Timeframe: This area must be completed before a student gains senior standing at Emory’s Atlanta Campus, so they are not required to graduated from Oxford.

Experience & Application
One “Experiential Learning” course is required for all students during their Oxford career. Experiential Learning courses are designated with an “E,” Experiential learning, or “learning through reflection on doing.” Examples of Experiential Learning opportunities may include Academic Internships, Advanced Student Research, Applied Arts, Global Learning, and Theory-Practice Service Learning. Students must complete:

Experience and Application [XA] - (1 course)
Timeframe: This area must be completed by Oxford graduation.

Success at Emory
All students in Oxford College are required to complete a set of two courses, jointly helping them achieve “Success at Emory.” This timed requirement supports the transition to Emory by helping students to develop skills for academic and personal success. Students must complete:

Milestone Reflection [MLP 101] (1 course taken on a S/U basis)
PE [PED] - (1 course)
Timeframe: PE must be taken in first year; MLP is taken in final semester of study. This area must be completed by graduation.

GOLD Plan General Education Program Requirements (Students entering Oxford Spring 2023 and earlier)
First-Year Writing Requirement
Students must satisfactorily complete the First-Year Writing Requirement during the first year of their enrollment at Oxford College. The requirement can be met with English 185: Critical Reading and Writing or with English 186: Critical Reading and Writing for Multilingual Students. Students may be eligible to exempt the First-Year Writing Requirement with appropriate Advanced Placement (AP) credit, International Baccalaureate (IB) credit, or transfer credit. Students may be placed in either English 185 or 186 based on their performance on the Directed Self Placement prior to the start of their first semester of study.

Continuing Writing Requirement
In addition to the First-Year Writing requirement, students must satisfactorily complete at least one writing-rich course at Oxford College. Students must attain a grade of a C or better in the writing-rich course to satisfy the Continuing Writing Requirement. Continued writing courses are designated with a W after the course catalog number in the class schedule and in OPUS.

Race and Ethnicity Requirement
Students must complete one course in this category. To fulfill this requirement, students must take at least one course that carries the Race and Ethnicity tag. Students may complete this requirement at Oxford College or on the Atlanta campus.

Distribution Requirements
Students must complete three of the five different academic areas listed below plus physical education requirements. All students are required to take at least one course in each of the following areas: SNT with lab, HSC, and HAP. In addition, Oxford students must complete a minimum of two (2) Ways of Inquiry (Q) courses, representing at least two of the five different academic areas. INQ courses are designated with a Q after the course catalog number in the class schedule and in OPUS.

Mathematics and Quantitative Reasoning (MQR)
To fulfill this area, students must complete at least one course that carries the TAG designation MQR. If credit is earned through AP or IB, then lower level courses in the sequence Mathematics 108/111/112 may not be taken for credit. As a general rule, students may earn credit through AP or IB, or by completing the comparable Oxford course, but not both.
Science, Nature, Technology (SNT)
To fulfill this area, students must complete at least two courses that carry the TAG designation SNT. All students must take at least one SNT course with lab to satisfy the GEP requirements.
Placement recommendation into any science course, excluding chemistry, is contingent on student profile (courses completed, standardized testing). Placement recommendation into any chemistry course is contingent on successful completion of an online placement module. Placement recommendation into any mathematics course is dependent on performance on the placement tests given during orientation which, in turn, is dependent on the online mathematics placement that each student needs to take before arriving. A student who anticipates concentrating in natural science at Emory should take a minimum of two courses in his or her chosen field, two courses in an allied science, and basic mathematics courses at Oxford.
History, Society, Cultures (HSC)
To fulfill this area, students must complete at least two courses that carry the TAG designation HSC. All students must take at least one HSC course to satisfy the GEP requirements.
Humanities, Arts, Performance (HAP)
To fulfill this area, students must complete at least two courses that carry the TAG designation HAP. All students must take at least one HAP course to satisfy the GEP requirements. English 185/English 186 cannot be used to satisfy the humanities requirement. English 399R, Music 300R, Music 300V, and Music 310 may not be used to fulfill the General Education program requirements.
Humanities, Arts, Language (HAL)
To fulfill this area, students must complete at least two foreign language courses in the same language. In addition, students may take additional language courses to fulfill the HAP requirement after completing the HAL requirement. Students are encouraged to complete this requirement at Oxford so that they may concentrate on work in their chosen major during their junior and senior years.
Physical Education (PED/PPF)
To fulfill this area, students must complete two semester hours in physical education Students are required to take one physical education class in their first year and one in their sophomore year, unless granted an exemption by the associate dean of academic affairs, in consultation with the academic coordinator and director of the Center for Healthful Living.

Physical activities for physical education classes may include vigorous movement. Students who have a medical condition that prevents them from fully participating in a physical education class, please contact the Office of Accessibility Services (OAS). The courses will be adjusted to fit the needs of the student so that the student will be able to meet the graduation requirements. If a student is incapacitated while enrolled in a course, adjustments for completing the course will be made with his/her instructor.

Discovery Seminar (DSC)
One Discovery Seminar course is required for all students during their first fall semester at Oxford College. Discovery Seminar courses are designated as DSC 101Q. This course will carry an academic area designation (MQR, SNT, HSC, HAP or HAL) as well as a Ways of Inquiry (Q) designation. The instructor of record for the Discovery Seminar will be assigned as the student's academic adviser. The DSC Faculty adviser will work with students during their two years at Oxford College.

Experiential Learning (E)
One "Experiential Learning" course is required for all students during their Oxford career. Experiential Learning courses are designated with an "E," Experiential Learning, or "Learning Through Reflection on Doing." Examples of Experiential Learning opportunities may include Academic Internships, Advanced Student Research, Applied Arts, Global Learning, and Theory-Practice Service Learning.

Ways of Inquiry (Q)
Students need to complete a minimum of two Ways of Inquiry (Q) courses designed to demonstrate how different disciplines investigate the world The Discovery Seminar course with a passing grade will count towards one of these courses. These courses must come from any two different academic areas.

Milestone Project (MLP)
One Milestone Project course is required for all students in their last regular semester before graduation. Through the Milestone Project and assistance from their Discovery Seminar faculty advisers, students will reflect on their liberal arts experience at Oxford College — including coursework, experiential learning, co-curricular experiences, or leadership endeavors — and explain how it has shaped them and their future plans. Students will synthesize through reflection, integrating the various elements of the portfolio into a coherent whole. Students will also adapt digital technologies and media to communicate for a specific academic audience and purpose. Finally, students will use reflective practice to put multiple perspectives, experiences, and contexts into conversation with each other to assess knowledge and performance and produce new insights.


"""

conv = Conversation(prompt, 2)

def predict(input, history=[]):
    history.append(input)
    response = conv.ask(input)
    history.append(response)
    responses = [(u,b) for u,b in zip(history[::2], history[1::2])]
    return responses, history

with gr.Blocks(css="#chatbot{height:350px} .overflow-y-auto{height:500px}") as demo:
    gr.Textbox("Hi, i am an expert of Emory Oxford GER, please tell me any questions you have for GER and i will help you out. Remember to specify your entering semester as the requirements may change depending on it", type="text")
    chatbot = gr.Chatbot(elem_id="chatbot")
    state = gr.State([])

    with gr.Row():
        txt = gr.Textbox(show_label=False, placeholder="Enter text and press enter").style(container=False)
    
    txt.submit(predict, [txt, state], [chatbot, state])

    

demo.launch()
