import gradio as gr
from transformers import pipeline
from youtube_transcript_api import YouTubeTranscriptApi


def youtube(url):
  video_id=url.split("=")[1]
  transcript=YouTubeTranscriptApi.get_transcript(video_id)
  result=""
  for i in transcript[0:100]:
    result+=i["text"]+" "+"\n"
  summarization=pipeline("summarization",model="facebook/bart-large-cnn",max_length=60,min_length=10)
  list_summarize=summarization(result)[0]["summary_text"].split(". ")
  result= ". ".join(list_summarize)
  return result

iface = gr.Interface(
    fn=youtube,
    inputs="text",
    outputs="text",
    layout="vertical",
    title="Video Özeti Oluşturucu",
    description="Bir YouTube videosunun URL'sini girin ve özetini alın."
)

iface.launch()