import gradio as gr
from fastai.vision.all import *
from fastcore.all import *

learn = load_learner("animal_species_detection.pkl")

categories = ("cat","horse","rabbit")

def classify_img(img):
    pred,idx,probs = learn.predict(img)
    return dict(zip(categories, map(float,probs)))

with gr.Blocks(title ="which animal is this ?") as demo:
    with gr.Row():
        gr.Markdown("""
                     ## Animal species detection
                     #### click on the photos to  and then click "PREDİCT" button
                     """)
    with gr.Row():
        image = gr.inputs.Image(shape=(192,192))   
    with gr.Row():
        output = gr.outputs.Label()      
    with gr.Row():
        image_button = gr.Button("PREDİCT")
        image_button.click(classify_img, inputs=image, outputs=output)
    
    with gr.Row():
        with gr.Column():
            gr.Examples(inputs=image,examples=["r1.jpg"],label="rabbit")
        with gr.Column():
            gr.Examples(inputs=image,examples=["r2.jpg"],label="rabbit")
        with gr.Column():
            gr.Examples(inputs=image,examples=["r2.jpg"],label="rabbit")
        with gr.Column():
                gr.Examples(inputs=image,examples=["h1.jpg"],label="horse")  
        with gr.Column():
                gr.Examples(inputs=image,examples=["h2.jpg"],label="horse") 
        with gr.Column():
                gr.Examples(inputs=image,examples=["h3.jpg"],label="horse") 
        with gr.Column():
                gr.Examples(inputs=image,examples=["c1.jpg"],label="cat") 
        with gr.Column():
                gr.Examples(inputs=image,examples=["c2.jpg"],label="cat")
        with gr.Column():
                gr.Examples(inputs=image,examples=["c3.jpg"],label="cat")
    
demo.launch()   

