import gradio as gr
import os
import sys
from pathlib import Path

models = [
    {"name": "7 Pa", "url": "AIARTCHAN/7pa"},
    {"name": "A Certain Model", "url": "JosephusCheung/ACertainModel"},
    {"name": "A Certain Thing", "url": "JosephusCheung/ACertainThing"},
    {"name": "A Certainity", "url": "JosephusCheung/ACertainty"},
    {"name": "Abyss Hell Hero", "url": "AIARTCHAN/AbyssHellHero"},
    {"name": "Abyss Maple 3", "url": "AIARTCHAN/AbyssMapleVer3"},
    {"name": "Abyss Orange Mix 2", "url": "WarriorMama777/AbyssOrangeMix2"},
    {"name": "Abyss Orange Mix", "url": "WarriorMama777/AbyssOrangeMix"},
    {"name": "AbyssHell 3", "url": "AIARTCHAN/AbyssHellVer3"},
    {"name": "Alice in Diffusion Land", "url": "Guizmus/SDArt_AliceInDiffusionLand"},
    {"name": "All 526 Animated", "url": "stablediffusionapi/all-526-animated"},
    {"name": "All 526", "url": "stablediffusionapi/all-526"},
    {"name": "Alloy Mix", "url": "p1atdev/alloy-mix"},
    {"name": "Alt Clip", "url": "BAAI/AltCLIP"},
    {"name": "Ambient Mix", "url": "OedoSoldier/ambientmix"},
    {"name": "AmiIReal", "url": "stablediffusionapi/amireal"},
    {"name": "Analog Diffusion", "url": "wavymulder/Analog-Diffusion"},
    {"name": "Anidosmix 3", "url": "AIARTCHAN/anidosmixV2"},
    {"name": "Anime Kawai Diffusion", "url": "Ojimi/anime-kawai-diffusion"},
    {"name": "Anime Screencap", "url": "Conflictx/AnimeScreencap"},
    {"name": "Animix", "url": "OedoSoldier/animix"},
    {"name": "Anireal 3D V2", "url": "circulus/sd-anireal-3d-v2"},
    {"name": "Any Pastel", "url": "m4gnett/any-pastel"},
    {"name": "AnyLORA", "url": "kubanemil/AnyLORA"},
    {"name": "Anything 2.1", "url": "swl-models/anything-v2.1"},
    {"name": "Anything 3.0 Light", "url": "mm00/anything-v3.0-light"},
    {"name": "Anything 3.0", "url": "Linaqruf/anything-v3.0"},
    {"name": "Anything 3.1", "url": "cag/anything-v3-1"},
    {"name": "Anything 3X", "url": "iZELX1/Anything-V3-X"},
    {"name": "Anything 5.0", "url": "stablediffusionapi/anything-v5"},
    {"name": "Anything Else 4", "url": "stablediffusionapi/anythingelse-v4"},
    {"name": "Anything Else 5", "url": "stablediffusionapi/anything-v5"},
    {"name": "Anything Midjourney 4.1", "url": "Joeythemonster/anything-midjourney-v-4-1"},
    {"name": "Arcane Diffusion", "url": "nitrosocke/Arcane-Diffusion"},
    {"name": "Archer Diffusion", "url": "nitrosocke/archer-diffusion"},
    {"name": "Asian Mix", "url": "D1b4l4p/AsianMix"},
    {"name": "Aurora", "url": "SweetLuna/Aurora"},
    {"name": "Balloon Art", "url": "Fictiverse/Stable_Diffusion_BalloonArt_Model"},
    {"name": "Blood Orange Mix", "url": "WarriorMama777/BloodOrangeMix"},
    {"name": "Blue pencil", "url": "bluepen5805/blue_pencil"},
    {"name": "CamelliaMix 2.5D","url": "stablediffusionapi/camelliamix25d"},
    {"name": "CamelliaMix Line","url": "stablediffusionapi/camelliamixline"},
    {"name": "Candy Punk", "url": "Conflictx/CandyPunk"},
    {"name": "Cetusmix", "url": "stablediffusionapi/cetusmix"},
    {"name": "CGI Animation", "url": "Conflictx/CGI_Animation"},
    {"name": "Chaos and Order", "url": "Guizmus/SDArt_ChaosAndOrder768"},
    {"name": "Chem Punk", "url": "Conflictx/Chempunk"},
    {"name": "Chikmix", "url": "stablediffusionapi/chikmix"},
    {"name": "Chillout App Factory","url": "stablediffusionapi/chillout-app-factory"},
    {"name": "Chilloutclara", "url": "Fred99774/chilloutvlara"},
    {"name": "Circulus 2.8", "url": "circulus/sd-photoreal-v2.8"},
    {"name": "Circulus Photoreal V2", "url": "circulus/sd-photoreal-real-v2"},
    {"name": "Circulus Semi Real 2", "url": "circulus/sd-photoreal-semi-v2"},
    {"name": "Clam", "url": "Johnhex/Clam"},
    {"name": "Clarity", "url": "Schisim/Clarity"},
    {"name": "Classic Anime", "url": "nitrosocke/classic-anim-diffusion"},
    {"name": "Claudfuen 1", "url": "claudfuen/photorealistic-fuen-v1"},
    {"name": "Collage Diffusion", "url": "wavymulder/collage-diffusion"},
    {"name": "Colorful 4.5", "url": "Manseo/Colorful-v4.5-Plus"},
    {"name": "Comic Diffusion", "url": "ogkalu/Comic-Diffusion"},
    {"name": "Complex-Lineart", "url": "Conflictx/Complex-Lineart"},
    {"name": "Cool Japan Diffusion 2.1.2", "url": "aipicasso/cool-japan-diffusion-2-1-2"},
    {"name": "Cool Japan Diffusion", "url": "aipicasso/cool-japan-diffusion-2-1-2"},
    {"name": "Cosmic Babes", "url": "stablediffusionapi/cosmic-babes"},
    {"name": "Cosmic Horros 768", "url": "Guizmus/SDArt_cosmichorrors768"},
    {"name": "Cosmic Horros", "url": "Guizmus/SDArt_cosmichorrors"},
    {"name": "Counterfeit 1.0", "url": "gsdf/counterfeit-v1.0"},
    {"name": "Counterfeit 2", "url": "gsdf/Counterfeit-V2.0"},
    {"name": "Counterfeit 2.0", "url": "gsdf/Counterfeit-V2.0"},
    {"name": "Counterfeit 3.0", "url": "stablediffusionapi/counterfeit-v30"},
    {"name": "CyberPunk Anime", "url": "DGSpitzer/Cyberpunk-Anime-Diffusion"},
    {"name": "Cyberrealistic", "url": "stablediffusionapi/cyberrealistic"},
    {"name": "Dark Sushi Mix", "url": "stablediffusionapi/dark-sushi-mix"},
    {"name": "Dash Sushi 25d", "url": "stablediffusionapi/dark-sushi-25d"},
    {"name": "Deliberate", "url": "Masagin/Deliberate"},
    {"name": "DGSpitzer", "url": "DGSpitzer/DGSpitzer-Art-Diffusion"},
    {"name": "Double Exposure Diffusion", "url": "joachimsallstrom/Double-Exposure-Diffusion"},
    {"name": "Dreamful 2", "url": "Hius/DreamFul-V2"},
    {"name": "DreamAnything", "url": "Yntec/DreamAnything"},
    {"name": "Dreamlike Anime", "url": "dreamlike-art/dreamlike-anime-1.0"},
    {"name": "Dreamlike Art", "url": "dreamlike-art/dreamlike-diffusion-1.0"},
    {"name": "Dreamlike Diffusion", "url": "dreamlike-art/dreamlike-diffusion-1.0"},
    {"name": "Dreamlike Photoreal", "url": "dreamlike-art/dreamlike-photoreal-2.0"},
    {"name": "Dreamshaper", "url": "Lykon/DreamShaper"},
    {"name": "DucHaiten Anime", "url": "DucHaiten/DucHaitenAnime"},
    {"name": "DucHaiten Art", "url": "DucHaiten/DucHaitenAIart"},
    {"name": "DucHaiten ClassicAnime", "url": "DucHaiten/DH_ClassicAnime"},
    {"name": "DucHaiten DreamWorld", "url": "DucHaiten/DucHaitenDreamWorld"},
    {"name": "DucHaiten Journey", "url": "DucHaiten/DucHaitenJourney"},
    {"name": "DucHaiten StyleLikeMe", "url": "DucHaiten/DucHaiten-StyleLikeMe"},
    {"name": "DucHaiten SuperCute", "url": "DucHaiten/DucHaitenSuperCute"},
    {"name": "Dungeons and Diffusion", "url": "0xJustin/Dungeons-and-Diffusion"},
    {"name": "Eerie Orange Mix", "url": "WarriorMama777/EerieOrangeMix"},
    {"name": "Eimis Anime Diffusion", "url": "eimiss/EimisAnimeDiffusion_1.0v"},
    {"name": "Elden Ring", "url": "nitrosocke/elden-ring-diffusion"},
    {"name": "Epic Diffusion 1.1", "url": "johnslegers/epic-diffusion-v1.1"},
    {"name": "Epic Diffusion", "url": "johnslegers/epic-diffusion"},
    {"name": "EpicMix Realism", "url": "Duskfallcrew/EpicMix_Realism"},
    {"name": "FantaStel", "url": "0RisingStar0/FantaStel"},
    {"name": "Fantasy Mix", "url": "theintuitiveye/FantasyMix"},
    {"name": "FeverDream", "url": "Cosmo-Hug/FeverDream"},
    {"name": "Fluid Art", "url": "Fictiverse/Stable_Diffusion_FluidArt_Model"},
    {"name": "Future Diffusion", "url": "nitrosocke/Future-Diffusion"},
    {"name": "Gakki Mix 768", "url": "Sa1i/gakki-mix-768"},
    {"name": "Ghibli Diffusion", "url": "nitrosocke/Ghibli-Diffusion"},
    {"name": "Girl New 1", "url": "Fred99774/girlnew1"},
    {"name": "Gorynich Mix", "url": "JackAnon/GorynichMix"},
    {"name": "GorynichMix", "url": "JackAnon/GorynichMix"},
    {"name": "GrapeFruit", "url": "iZELX1/Grapefruit"},
    {"name": "Grapefruit", "url": "stablediffusionapi/grapefruit-hentai-mo"},
    {"name": "Grimoeresigils", "url": "ECarbenia/grimoiresigils"},
    {"name": "GTA5 Artwork Diffusion", "url": "ItsJayQz/GTA5_Artwork_Diffusion"},
    {"name": "GuoFeng 3", "url": "xiaolxl/GuoFeng3"},
    {"name": "HARDBlend", "url": "theintuitiveye/HARDblend"},
    {"name": "HassanBlend 1.4", "url": "hassanblend/hassanblend1.4"},
    {"name": "HassanBlend 1.5.1.2", "url": "hassanblend/HassanBlend1.5.1.2"},
    {"name": "High Rise Mix 1", "url": "0RisingStar0/HighRiseMixV1"},
    {"name": "High Rise Mix 2", "url": "0RisingStar0/HighRiseMixV2"},
    {"name": "HimawariMixs", "url": "natsusakiyomi/HimawariMixs"},
    {"name": "Hrrzg Style 768px", "url": "TheLastBen/hrrzg-style-768px"},
    {"name": "Icomix 2", "url": "stablediffusionapi/icomix-2"},
    {"name": "InkPunk Diffusion", "url": "Envvi/Inkpunk-Diffusion"},
    {"name": "JWST Deep Space Diffusion", "url": "dallinmackay/JWST-Deep-Space-diffusion"},
    {"name": "Kipaki Egyptian Sci Fi", "url": "Conflictx/Kipaki-EgyptianSciFi"},
    {"name": "Lit 6B", "url": "hakurei/lit-6B"},
    {"name": "LiveArca Mix", "url": "0RisingStar0/LiveArcaMix"},
    {"name": "Lomo Diffusion", "url": "wavymulder/lomo-diffusion"},
    {"name": "Luna Diffusion", "url": "proximasanfinetuning/luna-diffusion"},
    {"name": "Majic Mix Fantasy", "url": "stablediffusionapi/majicmixfantasy"},
    {"name": "Majic Mix Realistic", "url": "stablediffusionapi/majicmixrealistic"},
    {"name": "Majic Mix Sombre", "url": "stablediffusionapi/majicmixsombre"},
    {"name": "Mama Orange Mixs", "url": "WarriorMama777/OrangeMixs"},
    {"name": "Marvel WhatIf Diffusion", "url": "ItsJayQz/Marvel_WhatIf_Diffusion"},
    {"name": "Meina Alter", "url": "stablediffusionapi/meinaalter"},
    {"name": "Meina Pastel", "url": "stablediffusionapi/meinapastel"},
    {"name": "MeinaMix 7", "url": "Nacholmo/meinamixv7-diffusers"},
    {"name": "MF-Base", "url": "MyneFactory/MF-Base"},    
    {"name": "Microscopic Model", "url": "Fictiverse/Stable_Diffusion_Microscopic_model"},
    {"name": "Midjourney 4.0", "url": "flax/midjourney-v4-diffusion"},
    {"name": "Midjourney 4.1", "url": "Joeythemonster/anything-midjourney-v-4-1"},
    {"name": "Mix Pro V4", "url": "AIARTCHAN/MIX-Pro-V4"},
    {"name": "Model Shoot", "url": "wavymulder/modelshoot"},
    {"name": "Mo-Di Diffusion", "url": "nitrosocke/mo-di-diffusion"},
    {"name": "MoistMix 1", "url": "MoistMix/MoistMixV1"},
    {"name": "Naruto Diffuser", "url": "lambdalabs/sd-naruto-diffusers"},
    {"name": "Never Ending Dream 2", "url": "luongphamit/NeverEnding-Dream2"},
    {"name": "NeverEnding-Dream", "url": "Lykon/NeverEnding-Dream"},
    {"name": "Nitro Diffusion", "url": "nitrosocke/Nitro-Diffusion"},
    {"name": "NotSoXJB", "url": "AerinK/NotSoXJB-Mix-1"},    
    {"name": "Openjourney 4", "url": "prompthero/openjourney-v4"},
    {"name": "Openjourney V2", "url": "prompthero/openjourney-v2"},
    {"name": "Openjourney", "url": "prompthero/openjourney"},
    {"name": "OpenNiji", "url": "Korakoe/OpenNiji"},
    {"name": "Papercut", "url": "Fictiverse/Stable_Diffusion_PaperCut_Model"},
    {"name": "Picasso Diffusion 1.1", "url": "aipicasso/picasso-diffusion-1-1"},
    {"name": "Plat Diffusion", "url": "p1atdev/plat-diffusion"},
    {"name": "Pokemon Diffuser", "url": "lambdalabs/sd-pokemon-diffusers"},
    {"name": "Portrait Plus", "url": "wavymulder/portraitplus"},
    {"name": "Protogen 2.2", "url": "darkstorm2150/Protogen_v2.2_Official_Release"},
    {"name": "Protogen Infinity", "url": "darkstorm2150/Protogen_Infinity_Official_Release"},
    {"name": "Protogen X 3.4", "url": "darkstorm2150/Protogen_x3.4_Official_Release"},
    {"name": "Protogen X 5.8", "url": "darkstorm2150/Protogen_x5.8_Official_Release"},
    {"name": "QuinceMix", "url": "Hemlok/QuinceMix"},
    {"name": "Realistic Vision 1.4", "url": "SG161222/Realistic_Vision_V1.4"},
    {"name": "Redshift 768", "url": "nitrosocke/redshift-diffusion-768"},
    {"name": "Redshift Diffusion 768", "url": "nitrosocke/redshift-diffusion-768"},
    {"name": "Redshift Diffusion", "url": "nitrosocke/redshift-diffusion"},
    {"name": "Replicant V2", "url": "gsdf/Replicant-V2.0"},
    {"name": "Replicant-V1.0", "url": "gsdf/Replicant-V1.0"},
    {"name": "Rev Anim", "url": "stablediffusionapi/rev-anim"},
    {"name": "Rev Animated", "url": "coreml/coreml-ReV-Animated"},
    {"name": "Rev Animated", "url": "LottePeisch/RevAnimated-Diffusers"},
    {"name": "Robo Diffusion 3 Base", "url": "nousr/robo-diffusion-2-base"},
    {"name": "Robo Diffusion", "url": "nousr/robo-diffusion"},
    {"name": "Salt_mix", "url": "AsAHuman/Salt_mix"},
    {"name": "Seek Art Mega", "url": "coreco/seek.art_MEGA"},
    {"name": "Semi Real Mix", "url": "robotjung/SemiRealMix"},
    {"name": "SEmix", "url": "Deyo/SEmix"},
    {"name": "Something V 2.2","url": "NoCrypt/SomethingV2_2"},
    {"name": "Something V2","url": "NoCrypt/SomethingV2"},
    {"name": "Something", "url": "Guizmus/SDArt_something"},
    {"name": "Spider Verse diffusion", "url": "nitrosocke/spider-verse-diffusion"},
    {"name": "SpyBG", "url": "stablediffusionapi/spybg"},
    {"name": "Stable Diffusion 1.4","url": "CompVis/stable-diffusion-v1-4"},
    {"name": "Stable Diffusion 1.5","url": "runwayml/stable-diffusion-v1-5"},
    {"name": "Stable Diffusion 2.1 Base","url": "stabilityai/stable-diffusion-2-1-base"},
    {"name": "Stable Diffusion 2.1 Unclip","url": "stabilityai/stable-diffusion-2-1-unclip"},
    {"name": "Stable Diffusion 2.1","url": "stabilityai/stable-diffusion-2-1"},
    {"name": "Subtly", "url": "ddPn08/subtly"},
    {"name": "Synthwave Punk 2", "url": "ItsJayQz/SynthwavePunk-v2"},
    {"name": "The Ally", "url": "stablediffusionapi/the-ally"},
    {"name": "Three Delicacy wonto", "url": "stablediffusionapi/three-delicacy-wonto"},
    {"name": "Three Delicacy", "url": "stablediffusionapi/three-delicacy"},
    {"name": "Timeless Diffusion", "url": "wavymulder/timeless-diffusion"},
    {"name": "TMND mix", "url": "stablediffusionapi/tmnd-mix"},
    {"name": "Tron Legacy Diffusion", "url": "dallinmackay/Tron-Legacy-diffusion"},
    {"name": "UltraSkin", "url": "VegaKH/Ultraskin"},
    {"name": "Valorant Diffusion", "url": "ItsJayQz/Valorant_Diffusion"},
    {"name": "Van Gogh Diffusion", "url": "dallinmackay/Van-Gogh-diffusion"},
    {"name": "Vectorartz Diffusion", "url": "coder119/Vectorartz_Diffusion"},
    {"name": "Vintedois 1.0", "url": "22h/vintedois-diffusion-v0-1"},
    {"name": "Vintedois 2.0", "url": "22h/vintedois-diffusion-v0-2"},
    {"name": "Vivid Watercolors", "url": "Evel/VividWatercolors"},
    {"name": "VoxelArt", "url": "Fictiverse/Stable_Diffusion_VoxelArt_Model"},
    {"name": "Waifu Diffusion", "url": "hakurei/waifu-diffusion"},
    {"name": "Wavyfusion", "url": "wavymulder/wavyfusion"},
    {"name": "West Magic", "url": "xiaolxl/WestMagic"},
    {"name": "X Mix", "url": "les-chien/X-mix"},
]

current_model = models[0]

text_gen = gr.Interface.load("spaces/daspartho/prompt-extend") 

models2 = []
for model in models:
    model_url = f"models/{model['url']}"
    loaded_model = gr.Interface.load(model_url, live=True, preprocess=True)
    models2.append(loaded_model)


def text_it(inputs, text_gen=text_gen):
    return text_gen(inputs)


def set_model(current_model_index):
    global current_model
    current_model = models[current_model_index]
    return gr.update(value=f"{current_model['name']}")


def send_it(inputs, model_choice):
    proc = models2[model_choice]
    return proc(inputs)


with gr.Blocks() as myface:
    gr.HTML(

    )

    with gr.Row():
        with gr.Row():
            input_text = gr.Textbox(label="Prompt idea",  placeholder="", lines=1)
            # Model selection dropdown
            model_name1 = gr.Dropdown(
                label="Choose Model",
                choices=[m["name"] for m in models],
                type="index",
                value=current_model["name"],
                interactive=True,
            )
        with gr.Row():
            see_prompts = gr.Button("Generate Prompts")
            run = gr.Button("Generate Images", variant="primary")
    
    with gr.Row():
        output1 = gr.Image(label="")
        output2 = gr.Image(label="")
        output3 = gr.Image(label="")
    with gr.Row():
        magic1 = gr.Textbox(label="Generated Prompt", lines=2)
        magic2 = gr.Textbox(label="Generated Prompt", lines=2)
        magic3 = gr.Textbox(label="Generated Prompt", lines=2)
    with gr.Row():
        output4 = gr.Image(label="")
        output5 = gr.Image(label="")
        output6 = gr.Image(label="")
    with gr.Row():
        magic4 = gr.Textbox(label="Generated Prompt", lines=2)
        magic5 = gr.Textbox(label="Generated Prompt", lines=2)
        magic6 = gr.Textbox(label="Generated Prompt", lines=2)

    model_name1.change(set_model, inputs=model_name1, outputs=[output1, output2, output3, output4, output5, output6])

    run.click(send_it, inputs=[magic1, model_name1], outputs=[output1])
    run.click(send_it, inputs=[magic2, model_name1], outputs=[output2])
    run.click(send_it, inputs=[magic3, model_name1], outputs=[output3])
    run.click(send_it, inputs=[magic4, model_name1], outputs=[output4])
    run.click(send_it, inputs=[magic5, model_name1], outputs=[output5])
    run.click(send_it, inputs=[magic6, model_name1], outputs=[output6])

    see_prompts.click(text_it, inputs=[input_text], outputs=[magic1])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic2])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic3])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic4])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic5])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic6])

myface.queue(concurrency_count=200)
myface.launch(inline=True, show_api=False, max_threads=400)