from iglovikov_helper_functions.utils.image_utils import load_rgb, pad, unpad
from iglovikov_helper_functions.dl.pytorch.utils import tensor_from_rgb_image
from cloths_segmentation.pre_trained_models import create_model
from PIL import Image
import numpy as np
import cv2
import torch
import albumentations as albu

def Segment(image: Image.Image, color=[255, 255, 255]):
    model = create_model("Unet_2020-10-30")
    model.eval()

    image = np.array(image)
    transform = albu.Compose([albu.Normalize(p=1)], p=1)
    padded_image, pads = pad(image, factor=32, border=cv2.BORDER_CONSTANT)

    x = transform(image=padded_image)["image"]
    x = torch.unsqueeze(tensor_from_rgb_image(x), 0)

    with torch.no_grad():
        prediction = model(x)[0][0]

    mask = (prediction > 0).cpu().numpy().astype(np.uint8)
    mask = unpad(mask, pads)

    mask_rgb = np.ones((*mask.shape, 3), dtype=np.uint8) * 255
    mask_rgb[mask == 1] = color

    return mask_rgb
