import gradio as gr
from PIL import Image
from fastapi import FastAPI
from process import Segment
import numpy as np

app = FastAPI()

def process_image(input_image):
    if not isinstance(input_image, Image.Image):
        input_image = Image.fromarray(input_image.astype('uint8'), 'RGB')
    
    output_image = Segment(input_image, [0, 0, 0])
    return output_image

iface = gr.Interface(
    fn=process_image, 
    inputs=gr.components.Image(type="numpy"), 
    outputs=gr.components.Image(type="numpy")
)

iface.launch()
