import gradio as gr
from inference_main import infer
import wave
def interference(wav_file, trans=0):
    # determine if wav_file is .wav
    # then, inference
    # return the result
    # if the wav_file is not .wav, inform the user and let user re upload the file
    
    # ME: 
    # if wav_file length > 30s or < 1s, inform the user and let user re upload the file
    f = wave.open(wav_file, 'rb')
    time_count = f.getnframes() / f.getframerate()
    if time_count > 30 or time_count < 1:
        return None, "Please upload a .wav file with length between 1s and 30s"
    if  not wav_file.endswith('.wav'):
        return None, "Please upload a .wav file"
    return infer(wav_file, trans=[trans]), "Succeed"
    
    
# write a gr.Interface that accept a wav file
iface = gr.Interface(
  fn=interference,
  title="Singing Voice Conversion(TokaiTeio)",
  inputs=[gr.inputs.Audio(type="filepath", label="Input Audio"), gr.inputs.Number(default=0, label="音高变换")],
  outputs=[gr.outputs.Audio(type="numpy", label="Inferenced Audio"), "text"]
)
iface.launch()