#!/bin/bash
NAME="testfordocker"
PORT=7860
APP_PATH="/app"

## 1. stop old container
docker stop $NAME

## 2. remove old container and images
docker rm $NAME && docker rmi $NAME

## 3. build new image
docker build -t $NAME .

## 4. run container
docker run -itd --name $NAME -p $PORT:7860 -v "$(pwd)/app":$APP_PATH $NAME

echo "CONTAINER IS RUNNING AS $NAME ON $PORT"