from fastbook import *
from random import sample
import gradio as gr

def get_images():
    listOfCats = sorted(['Lioness', 'Lion', 'Tiger', 'White tiger', 'White lion', \
                'Leopard', 'Snow leopard', 'Lynx', 'Jaguar', 'Cheetah', \
                'Jaguarundi', 'Leopard cat', 'Canada lynx', 'Caracal', \
                'Ocelot', 'Leopard cat', 'Marble cat', 'Puma', 'Black panther', \
                'Margay', 'Serval', 'Fishing cat'])
    cats = sample(listOfCats, len(listOfCats))[:2]
    imagess = [sample(search_images_ddg(f'{cat} photo', max_images=5), 5) for cat in cats]
    return [images[:1] for images in imagess]

def quiz_builder(input):
    model = load_learner("cats.pkl")
    is_it, _, probs = model.predict(input)
    return f"The cat in this image is a {is_it}!"
    # return {is_it: f"{max(probs[0], probs[1], probs[2]):.4f}"}

demo = gr.Interface(
    quiz_builder,
    [
        gr.Image(value=None)
    ],
    "text",
    examples=[
        *get_images(),
    ]
)

if __name__ == "__main__":
    demo.launch()
