# AUTOGENERATED! DO NOT EDIT! File to edit: app.ipynb.

# %% auto 0
__all__ = ['learn', 'species', 'image', 'label', 'examples', 'intf', 'classify_image']

# %% app.ipynb 1
from fastai.vision.all import *
import timm
import gradio as gr

# %% app.ipynb 3
learn = load_learner('hummingbird_classifier_convb.pkl')

# %% app.ipynb 5
species = ('Adelomyia melanogenys', 'Aglaiocercus coelestis', 'Aglaiocercus kingii', 'Amazilia amabilis',
        'Amazilia franciae', 'Amazilia rosenbergi', 'Amazilia saucerottei', 'Amazilia tzacatl',
        'Androdon aequatorialis', 'Anthracothorax nigricollis', 'Boissonneaua flavescens', 
        'Boissonneaua jardini', 'Chaetocercus heliodor', 'Chaetocercus mulsant', 'Chalybura buffonii',
        'Chalybura urochrysia', 'Chlorostilbon gibsoni', 'Chlorostilbon melanorhynchus', 
        'Chrysolampis mosquitus', 'Coeligena coeligena', 'Coeligena torquata', 'Colibri coruscans',
        'Colibri delphinae', 'Colibri thalassinus', 'Discosura conversii', 'Doryfera ludovicae',
        'Ensifera ensifera', 'Eriocnemis vestita', 'Eutoxeres aquila', 'Florisuga mellivora', 
        'Glaucis hirsutus', 'Haplophaedia aureliae', 'Heliangelus exortis', 'Heliodoxa imperatrix',
        'Heliodoxa jacula', 'Heliodoxa leadbeateri', 'Heliodoxa rubinoides', 'Heliomaster longirostris',
        'Heliothryx barroti', 'Hylocharis eliciae', 'Klais guimeti', 'Lafresnaya lafresnayi',
        'Lepidopyga coeruleogularis', 'Lepidopyga goudoti', 'Metallura tyrianthina', 'Ocreatus underwoodii',
        'Phaethornis anthophilus', 'Phaethornis guy', 'Phaethornis longirostris', 'Phaethornis striigularis',
        'Phaethornis syrmatophorus', 'Phaethornis yaruqui', 'Ramphomicron microrhynchum', 'Schistes geoffroyi',
        'Threnetes ruckeri', 'Urochroa bougueri')

def classify_image(img):
    pred, idx, probs = learn.predict(img)
    return dict(zip(species, map(float, probs)))

# %% app.ipynb 7
title = 'Colombia - Antioquia Hummingbird Species Classifier'
image = gr.components.Image(shape=(192, 192))
label = gr.components.Label()
examples = ['lead.webp', 'geo.jpg', 'delphinae.jpg', 'jardini.jpg', 'tzacatl.jfif', 'micro.jfif']

intf = gr.Interface(fn=classify_image, title=title, inputs=image, outputs=label, examples=examples)
intf.launch(inline=False)
