import os
import json
import openai
import gradio as gr
import warnings

warnings.filterwarnings('ignore')

#os.environ["HTTP_PROXY"] = "http://127.0.0.1:10809"
#os.environ["HTTPS_PROXY"] = "http://127.0.0.1:10809"
messages = [
    {"role": "system", "content": "You are a helpful and kind AI Assistant."}
]


def get_api_key():
    openai_key_file = './envs/openai_key'
    with open(openai_key_file, 'r', encoding='utf-8') as f:
        openai_key = json.loads(f.read())
    return openai_key['api']


def chatbot(input):
    if input:
        messages.append({"role": "user", "content": input})
        chat = openai.ChatCompletion.create(
            model="gpt-3.5-turbo", messages=messages
        )
        reply = chat.choices[0].message.content
        messages.append({"role": "assistant", "content": reply})
    return reply


if __name__ == '__main__':
    openai.api_key = get_api_key()
    inputs = gr.inputs.Textbox(lines=7, label="Chat with AI")
    outputs = gr.outputs.Textbox(label="Reply")

    gr.Interface(fn=chatbot, inputs=inputs, outputs=outputs, title="AI Chatbot",
                 description="Ask anything you want",
                 theme="compact").launch()