from llama_index import SimpleDirectoryReader, GPTListIndex, readers, GPTSimpleVectorIndex, LLMPredictor, PromptHelper, ServiceContext
from langchain.chat_models import ChatOpenAI
import sys
import os
from IPython.display import Markdown, display
import gradio as gr
import openai



os.environ["OPENAI_API_KEY"] = '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'



def construct_index(directory_path):
    max_input_size = 40096
    num_outputs = 20000
    max_chunk_overlap = 20
    chunk_size_limit = 600
    
    prompt_helper = PromptHelper(max_input_size, num_outputs, max_chunk_overlap, chunk_size_limit=chunk_size_limit)

    llm_predictor = LLMPredictor(llm=ChatOpenAI(temperature=0.7, model_name="gpt-3.5-turbo", max_tokens=num_outputs))

    documents = SimpleDirectoryReader(directory_path).load_data()
    service_context = ServiceContext.from_defaults(llm_predictor=llm_predictor, prompt_helper=prompt_helper)
    index = GPTSimpleVectorIndex.from_documents(documents, service_context=service_context)

    index.save_to_disk('index.json')

    return index

def chatbot_fix_text(texto):
    texto_novo = ""
    quantidade_pontos = texto.count('.')
    x = 0
    texto = texto.strip()

    while x < quantidade_pontos:
      index_texto = texto.index('.') + 1
      texto_esquerda = texto[0:index_texto]
      texto_direita = texto[index_texto + 1:len(texto)]      
      texto = texto_direita
      x += 1
      if x == quantidade_pontos:
        texto_novo += texto_esquerda
      else:
        texto_novo += texto_esquerda + "\n"

    return texto_novo

def chatbot(input_text):
    Adds ='Você é uma AI especializada. \n' + ' Caso não encontre nada na documentação fornecida diga que você é uma AI especializada e não pode responder. "'

    index = GPTSimpleVectorIndex.load_from_disk('index.json')
    response = index.query(Adds + input_text, response_mode="default")
    return chatbot_fix_text(response.response) 

def ask_ai():
    index = GPTSimpleVectorIndex.load_from_disk('index.json')
    while True: 
        query = input("What do you want to ask? ")
        response = index.query(query)
        display(Markdown(f"Response: <b>{response.response}</b>"))


def clear():
    return None, None

css = """
:root {
  background: transparent url("https://i.ibb.co/2hNBsDp/bg2.jpg") no-repeat scroll left center;
  background-size: 100% 100%;
  --body-background-fill: transparent !important;
  --background-fill-primary: transparent !important;
  --text-xxs: 0.6vw !important;
  --text-xs: 0.8vw  !important;
  --text-sm: 1.0vw  !important;
  --text-md: 1.2vw  !important;
  --text-lg: 1.4vw !important;
  --text-xl: 1.6vw !important;
  --text-xxl: 1.9vw !important;
}

.cabecalho {   
  flex-direction: row;
  justify-content: space-between;
  height: 6rem;
}

#tac-logo{
  width: 35%;
  border: none !important;  
  box-shadow: none;
  margin: auto 0 auto auto;
  text-align: right !important;
}

#titulo {
  text-align: center;
  color: rgb(128,128,128);
  font-style: Garamond, serif;
  border: none !important;
  box-shadow: none;
}

#prefeitura-logo{
  width: 45%;
  border: none !important;  
  box-shadow: none;
  margin: auto auto auto 0;
}

.svelte-vt1mxs.gap{
  flex-grow: 1 !important;
  flex-shrink: 1 !important;
  min-width: min(0px, 100%) !important;
}

.form.svelte-b6y5bg
{
  background-color: white;
}

.svelte-ms5bsk {
  margin: auto 0 0 auto !important;
  text-align: right !important;
  justify-content: right !important;
  align-items: end !important;
}

#submit-btn {
  color:
}

#empty-title{
  box-shadow: none;
  border: none !important;
}


.svelte-vt1mxs {
  flex-wrap: nowrap !important;
}
.svelte-15lo0d8 {
  flex-wrap: nowrap !important;
}

.svelte-1sohkj6.float {
  visibility: hidden;
}

.download.svelte-ms5bsk {
  display: none;
}

.show-api.svelte-1lyswbr{
  display: none !important;
}

.built-with.svelte-1lyswbr{
  display: none !important;  
}
"""

with gr.Blocks(theme=gr.themes.Default(),css=css) as iface:
  fn = chatbot,
  with gr.Row():
    with gr.Column():
      img2 = gr.Image("prefeitura-logo.jpg", elem_id = "prefeitura-logo", elem_classes="cabecalho", show_label = 'false');   
    with gr.Column():
      titulo = gr.Label("IA-ChatGPT Pauliteiros", elem_id = "titulo", elem_classes="cabecalho")
    with gr.Column():
      empty = gr.Label("", elem_id = "titulo", elem_classes="cabecalho")
  with gr.Row():
    input = gr.Textbox(lines=3, label="Digite sua pergunta")
  with gr.Row():
    output = gr.Textbox(lines=6, label="Resposta")
  with gr.Row().style(equal_height=True):
    with gr.Column():                    
      clear_btn = gr.Button("Clear")
      clear_btn.click(fn=clear, inputs=None, outputs=[input, output])
    with gr.Column(): 
      submit_btn = gr.Button("Submit")
      submit_btn.click(fn=chatbot, inputs=input, outputs=output, api_name="submit")
  with gr.Row():
    with gr.Column():
      empty = gr.Label("", elem_id = "titulo", elem_classes="cabecalho")
    with gr.Column():
      empty = gr.Label("", elem_id = "titulo", elem_classes="cabecalho")    
    with gr.Column():
      img1 = gr.Image("tac-logo.png", elem_id = "tac-logo", elem_classes="cabecalho", show_label = 'false');
        

iface.launch()