import streamlit as st

try:

    from RAG import pipeline

    st.title("Ask your scientific question! 👨‍⚕")
    expected_format = "What is color?\nA)Is a name.\nB)Is something horrible.\nC)I don't know.\nD)You should ask someone else.\nE)Ask in a pyshic book."
    txt = st.text_area(
        "follow this format while making your question:",
        expected_format)
    try:
        lista = txt.split("E)")
        e = lista[1]
        lista = lista[0].split("D)")
        d = lista[1]
        lista = lista[0].split("C)")
        c = lista[1]
        lista = lista[0].split("B)")
        b = lista[1]
        lista = lista[0].split("A)")
        a = lista[1]
        q = lista[0]

        mi_dict= {
            "prompt":q,
            "A":a,
            "B":b,
            "C":c,
            "D":d,
            "E":e
        }

        multi = f'''
        ---
        :green[**Question**] 🔎

        {mi_dict["prompt"]}

        :green[**Options**] 📗

        * :blue[**A**] {mi_dict["A"]}
        * :blue[**B**] {mi_dict["B"]}
        * :blue[**C**] {mi_dict["C"]}
        * :blue[**D**] {mi_dict["D"]}
        * :blue[**E**] {mi_dict["E"]}
        ---
        '''
        st.markdown(multi)

        try:    
            if st.button('Ask for answer'):
                answer = pipeline.give_the_best_answer(mi_dict)
                st.write(f"The correct answer is {answer}: {mi_dict[answer]}")
                st.balloons()

        except Exception as e:
            st.error("Something bad happend while trying to infer the answer or with the buttons.")
            st.error(e)

    except Exception as e:
        st.error("Your question doesn't have the required format. Please, correct it.")
        st.error(e)

except Exception as e:
    st.error("Error most likely related to the import of the object 'pipeline'")
    st.error(e)