import os
from transformers import pipeline


# Load the summarization pipeline
summarizer = pipeline("summarization", model="facebook/bart-large-cnn")

def summarize(input):
  output = summarizer(input)
  return output[0]['summary_text']
  
import gradio as gr
demo = gr.Interface(fn=summarize, 
                    inputs = [gr.Textbox(label="Text to summarize", line=6)],
                    outputs=[gr.Textbox(label="Result", lines=3)],
                    title="Text summarization with bart-cnn",
                    description="Summarize any text using the `facebook/bart-large-cnn` model under the hood!")

demo.launch(share=True)