import gradio as gr
import transformers
from transformers import pipeline
import torch 

pipeline = pipeline(task="text-classification", model="JosephTK/NLP-reviews",
                    return_all_scores=True)

def classify(text):
    predictions = pipeline(text)[0]
    return {p["label"]: p["score"] for p in predictions}


gr.Interface(
    classify,
    inputs=gr.Textbox(value="The food was delicious", label="Input Text"),
    outputs=gr.Label(num_top_classes=5),
    title="Review analyzer",
).launch()