from torch import nn
import torch
import torchvision
def create_effnet_b2():
  weights = torchvision.models.EfficientNet_B2_Weights.DEFAULT
  transform = weights.transforms()
  effnet_b2 = torchvision.models.efficientnet_b2(weights=weights)
  torch.manual_seed(42)
  for params in effnet_b2.parameters():
    params.requires_grad = False
  effnet_b2.classifier = nn.Sequential(
      nn.Dropout(p=0.3,inplace=True),
      nn.Linear(in_features=1408,
                out_features=1)
  )
  return effnet_b2,transform
