import gradio as gr
import os
import torch
from model import create_effnet_b2

class_names = ["cat","dog"]
model,transform = create_effnet_b2()
model.load_state_dict(torch.load(
    f="best_model.pth",
    map_location=torch.device("cpu")))
def pred(img):
  transformed_image = transform(img).unsqueeze(dim=0)
  model.eval()
  with torch.inference_mode():
    y_logit = model(transformed_image)
    y_pred = torch.round(torch.sigmoid(y_logit)).squeeze().item()
    result = class_names[int(y_pred)]
  return result
example_list = [["examples/" + example] for example in os.listdir("examples")]
title = "Dog or Cat...."
description = "An Efficent net B2 model to predict on cat and dog images."
demo = gr.Interface(fn=pred,
                    inputs=gr.Image(type="pil"),
                    outputs=gr.Label(label="Prediction"),
                    examples=example_list,
                    title=title,
                    description=description)
demo.launch()
