from random import choices
import numpy as np
import gradio as gr
from glob import glob
from huggingface_hub import from_pretrained_keras

model = from_pretrained_keras('Jorgvt/CycleGAN_GTA_REAL', compile=False)

def transform(img, direction):
    img = (img / 127.5) - 1
    if direction==0:
        pred = model.generator_g.predict(img[None,:,:,:])[0]
    else:
        pred = model.generator_f.predict(img[None,:,:,:])[0]
    pred = (pred-pred.min())/(pred.max()-pred.min())
    pred = (pred * 255).astype(np.uint8)
    return pred

examples_gta = [[path, 'GTA->REAL'] for path in glob('Examples/gta*')]
examples_real = [[path, 'REAL->GTA'] for path in glob('Examples/real*')]
examples = [*examples_gta, *examples_real]

demo = gr.Interface(fn=transform, 
                    inputs=[gr.inputs.Image(shape=(256, 256), type='numpy'),
                            gr.inputs.Radio(choices=['GTA->REAL', 'REAL->GTA'],
                                            type='index')], 
                    outputs=gr.outputs.Image(type='numpy'),
                    examples=examples)

if __name__ == '__main__':
    demo.launch()