from shiny import App, Inputs, Outputs, Session, reactive, render, ui
import shinyswatch

from pathlib import Path

# Importar la interfaz y los servidores de los componentes
from learningTool import learningTool_ui, learningTool_server
from customTool import customTool_ui, customTool_server
from ExtraInfo.extraInfo import extra_info_Python_programming_ui, extra_info_project_info_ui


############################## COMPROBACIONES DE PATH Y CARPETAS #############################

# Creación / comprobación de las carpetas para guardar las imágenes de plots de árboles:
Path(Path(__file__).parent / 'DecTrees').mkdir(exist_ok=True)
Path(Path(__file__).parent / 'RanForests').mkdir(exist_ok=True)



##############################################################################################
########################################## UI ################################################
##############################################################################################

app_ui = ui.page_fluid(
    # Available themes:
        #  cerulean, cosmo, cyborg, darkly, flatly, journal, litera, lumen, lux,
        #  materia, minty, morph, pulse, quartz, sandstone, simplex, sketchy, slate,
        #  solar, spacelab, superhero, united, vapor, yeti, zephyr
        # Good ones: cerulean, litera, materia, pulse, slate, spacelab, superhero, zephyr
        # Funny: sketchy, vapor
    shinyswatch.theme.cerulean(),
    
    # Estilo especial sobreescito al estilo del tema utilizado para hacer los botones más intuitivos
    # y mejorar el feedback recibido por la interacción con ellos 
    ui.tags.style(
        """
        button {
            border: 1px solid DimGray !important;
            box-shadow: 0 4px DarkGray !important;
            transition: 0.1s !important;
        }
        button:hover {
            border: 1px solid DimGray !important;
            transform: translateY(-2px) !important;
            box-shadow: 0px 6px Silver !important;
        }
        button:active {
            border: 1px solid DimGray !important;
            box-shadow: 0 2px DimGray !important;
            transform: translateY(2px) !important;
        }
        """
    ),

    ui.page_navbar(
        ui.nav_spacer(),
#################################### HERRAMIENTA INTERACTIVA #################################
        ui.nav(
            "Herramienta Interactiva",
            learningTool_ui("learning_tool"),            
        ),
#################################### USA DATOS PROPIOS #######################################
        ui.nav(
            "¡Usa tus datos!",
            customTool_ui("custom_tool"),
        ),
#################################### EXTRA ###################################################
        ui.nav(
            "Extra",
            ui.panel_main(
                extra_info_Python_programming_ui("extra_info"),
                ui.tags.hr(),
                width=12
            ),
            ui.panel_main(
                extra_info_project_info_ui("extra_info"),
                width=12
            ),
        ),

        title="Herramienta Interactiva", #para la enseñanza de técnicas de aprendizaje supervisado en salud",
        window_title="Herramienta Interactiva para enseñanza de ML by Jorge Ruiz",
        lang="es",
        bg="#006ee6",
        #collapsible=True,
        position="static-top",
    )
)




##############################################################################################
######################################## SERVER ##############################################
##############################################################################################

def server(input: Inputs, output: Outputs, session: Session):
    
############### SERVIDORES INDIVIDUALES DE LOS COMPONENTES INTEGRADOS ########################
    
    learningTool_server("learning_tool")
    customTool_server("custom_tool"),





##############################################################################################
##################################### SHINY APP ##############################################
##############################################################################################

app = App(app_ui, server)