from shiny import module, ui, render

@module.ui
def custom_new_dataframe_warning_ui():
    return ui.div(
        ui.output_text("new_dataframe_warning"),
        style="color:red; width:90%; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_new_dataframe_warning_empty_ui():
    return ui.div(
        ui.output_text("new_dataframe_warning_empty"),
        style="color:red; width:90%; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_new_dataframe_accepted_ui():
    return ui.div(
        ui.output_text("new_dataframe_accepted"),
        style="color:green; width:90%; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_missing_data_table_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_table_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_missing_data_types_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_types_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_missing_data_histogram_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_histogram_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )




@module.server
def warnings_custom_no_data_server(input, output, session):

    # WARNINGS DE DATAFRAMES IMPORTADAS
    @output
    @render.text
    def new_dataframe_warning():
        return "¡Introduce un dataframe válido! Se permiten archivos .csv y .xls / .xlsx."
    
    @output
    @render.text
    def new_dataframe_warning_empty():
        return "¡Introduce un dataframe válido! El tipo de archivo es válido pero está vacío o no se puede leer."
    
    @output
    @render.text
    def new_dataframe_accepted():
        return "¡El dataframe cargado es válido!"
    
    # WARNINGS CUSTOM DATAFRAME NO SE HA IMPORTADO
    @output
    @render.text
    def custom_missing_data_table_txt():
        return "¡La base de datos no se ha importado! No se puede mostrar la tabla."
    
    @output
    @render.text
    def custom_missing_data_types_txt():
        return "¡La base de datos no se ha importado! No se pueden mostrar los tipos de datos."
    
    @output
    @render.text
    def custom_missing_data_histogram_txt():
        return "¡La base de datos no se ha importado! No se puede mostrar el histograma de los datos."
    

    
