from shiny import module, ui, render



##############################################################################################
####################################### MÓDULOS DE UI ########################################
##############################################################################################

############################## CUSTOM: LIMPIEZA DE LOS DATOS #################################

@module.ui
def custom_missing_data_clean_table_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_clean_table_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_missing_data_clean_types_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_clean_types_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_missing_data_clean_hist_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_clean_hist_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_missing_data_clean_hist_div_outcome_warning_ui():
    return ui.div(
        ui.output_text("custom_missing_data_clean_hist_div_outcome_txt"),
        
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_too_many_unique_clean_hist_div_outcome_warning_ui():
    return ui.div(
        ui.output_text("custom_too_many_unique_clean_hist_div_outcome_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )


############################## CUSTOM: CORRELACIÓN DE LOS DATOS ##############################

@module.ui
def custom_correlation_warning_ui():
    return ui.div(
        ui.output_text("custom_correlation_warning_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )

@module.ui
def custom_correlation_no_data_warning_ui():
    return ui.div(
        ui.output_text("custom_correlation_warning_no_data_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding: 10px; background: #f7f7f7; border-radius: 10px;"
    )


##############################################################################################
##################################### MÓDULO DE SERVIDOR #####################################
##############################################################################################

@module.server
def warnings_custom_general_server(input, output, session):

############################## CUSTOM: LIMPIEZA DE LOS DATOS #################################

    # WARNINGS BASE DE DATOS NO SE HA IMPORTADO
    @output
    @render.text
    def custom_missing_data_clean_table_txt():
        return "¡La base de datos no se ha importado! No se puede mostrar la tabla de datos limpios."
    
    @output
    @render.text
    def custom_missing_data_clean_types_txt():
        return "¡La base de datos no se ha importado! No se puede mostrar los tipos de datos limpios."
    
    @output
    @render.text
    def custom_missing_data_clean_hist_txt():
        return "¡La base de datos no se ha importado! No se puede mostrar el histograma de los datos limpios."
    
    @output
    @render.text
    def custom_missing_data_clean_hist_div_outcome_txt():
        return "¡La base de datos no se ha importado! No se puede mostrar el histograma de los datos limpios divididos por la variable a predecir."
    
    @output
    @render.text
    def custom_too_many_unique_clean_hist_div_outcome_txt():
        return "La variable a predecir tiene demasiados valores únicos para mostrar este histograma."
    

############################## CUSTOM: CORRELACIÓN DE LOS DATOS ##############################

    # WARNINGS CORRELACIÓN
    @output
    @render.text
    def custom_correlation_warning_txt():
        return "Los datos para predecir deben ser numéricos antes de continuar."
    
    @output
    @render.text
    def custom_correlation_warning_no_data_txt():
        return "La base de datos no se ha importado! No se puede mostrar la tabla de correlación."