from shiny import module, ui, render

@module.ui
def custom_no_data_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_no_data_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_outcome_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_outcome_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_features_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_features_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_features_non_numeric_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_features_non_numeric_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_features_nan_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_features_nan_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_test_split_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_test_split_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_test_split_low_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_test_split_low_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def custom_test_split_high_warning_ui():
    return ui.div(
        ui.output_text("custom_warning_test_split_high_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )




@module.server
def warnings_custom_algorithms_server(input, output, session):

    @output
    @render.text
    def custom_warning_no_data_txt():
        return "¡La base de datos no se ha importado! No se puede crear el modelo de predicción."

    @output
    @render.text
    def custom_warning_outcome_txt():
        return "¡Los datos de predicción han tenido que ser convertidos previamente a numéricos para generar el modelo!"

    @output
    @render.text
    def custom_warning_features_txt():
        return "¡Se necesita al menos una característica para poder general el modelo!"
    
    @output
    @render.text
    def custom_warning_features_non_numeric_txt():
        return "¡Todos los datos de usados para generar el modelo deben de ser numéricos!"
    
    @output
    @render.text
    def custom_warning_features_nan_txt():
        return "¡Ningún dato usado para generar el modelo puede tener valores nulos!"
    
    @output
    @render.text
    def custom_warning_test_split_txt():
        return "¡Los datos han tenido que ser separados en subsets de entrenamiento y testeo anteriormente!"
    
    @output
    @render.text
    def custom_warning_test_split_low_txt():
        return "¡No se puede generar el modelo si no hay ningun dato en el subset de testeo! El valor de su tamaño es demasiado pequeño, cámbialo y ejecuta la división de los subsets."
    
    @output
    @render.text
    def custom_warning_test_split_high_txt():
        return "¡No se puede generar el modelo si no hay ningun dato en el subset de entrenamiento! El valor del tamaño del subset de testeo es demasiado grande, cámbialo y ejecuta la división de los subsets."