from shiny import module, ui, render

@module.ui
def diagnosis_warning_ui():
    return ui.div(
        ui.output_text("warning_diagnosis_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def test_split_warning_ui():
    return ui.div(
        ui.output_text("warning_test_split_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def test_split_low_warning_ui():
    return ui.div(
        ui.output_text("warning_test_split_low_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def test_split_high_warning_ui():
    return ui.div(
        ui.output_text("warning_test_split_high_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def features_warning_ui():
    return ui.div(
        ui.output_text("warning_features_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def feat_imp_warning_ui():
    return ui.div(
        ui.output_text("warning_feat_imp_txt"),
        style="color:red; font-style:italic; margin-top:20px; margin-bottom:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )

@module.ui
def conf_matrix_warning_ui():
    return ui.div(
        ui.output_text("warning_conf_matrix_txt"),
        style="color:red; font-style:italic; margin-top:20px; padding:10px; background:#f7f7f7; border-radius:10px;"
    )




@module.server
def warnings_algorithms_server(input, output, session):

    @output
    @render.text
    def warning_diagnosis_txt():
        return "¡Los datos de diagnosis han tenido que ser convertidos previamente para generar el modelo!"
    
    @output
    @render.text
    def warning_test_split_txt():
        return "¡Los datos han tenido que ser separados en subsets de entrenamiento y testeo anteriormente!"
    
    @output
    @render.text
    def warning_test_split_low_txt():
        return "¡No se puede generar el modelo si no hay ningun dato en el subset de testeo! El valor de su tamaño es demasiado pequeño, cámbialo y ejecuta la división de los subsets."
    @output
    @render.text
    def warning_test_split_high_txt():
        return "¡No se puede generar el modelo si no hay ningun dato en el subset de entrenamiento! El valor del tamaño del subset de testeo es demasiado grande, cámbialo y ejecuta la división de los subsets."

    @output
    @render.text
    def warning_features_txt():
        return "¡Se necesita al menos una característica para generar el modelo!"
    
    @output
    @render.text
    def warning_feat_imp_txt():
        return "¡No se puede calcular la importancia de las variables sin haber creado el modelo!"
    
    @output
    @render.text
    def warning_conf_matrix_txt():
        return "¡No se puede mostrar la matriz de confusión sin haber creado el modelo!"
    

    
