from shiny import module, ui, reactive

@module.ui
def subsetSplit_1_ui():
    return ui.div(
        {"id": "test_split_info"},
        ui.tags.p("Antes de implementar cualquier algoritmo de aprendizaje supervisado siempre se debe realizar la división de los datos disponibles en dos partes, una para entrenar el modelo y otra para probarlo."
                    , style="padding-right:50px; text-align: justify; text-justify: inter-word;"),
        ui.input_action_button("show_why_split", "¿Para qué se realiza la división de los datos? ▽"
                                , style="padding: 0px 0px 10px 0px; background: white; border: none; font-weight: bold; text-decoration: underline; border: 0 !important; box-shadow: 0 0 !important; transition: 0.1s !important; background-color: transparent !important;"),
    )

@module.ui
def subsetSplit_2_ui():
    return ui.div(
        ui.div(
            ui.markdown("A continuación puedes **elegir el tamaño del subconjunto de prueba** y dividir los datos. Se suele recomendar que el subconjunto de prueba sea de **entre el 20% y 30%** de todos los datos.")
            , style="padding-right:50px; padding-top:20px; text-align: justify; text-justify: inter-word;" 
        ),
    )


@module.server
def subsetSplit_server(input, output, session):
    
    @reactive.Effect
    @reactive.event(input.show_why_split)
    def _():
        show_why_split_button = input.show_why_split()
        if show_why_split_button % 2 == 1:
            ui.update_action_button("show_why_split", label="¿Para qué se realiza la división de los datos? △")
            ui.insert_ui(
                ui.div({"id": "inserted-why-split-info"},
                    ui.markdown("""Dividir los datos en un subconjunto de entrenamiento y otro de prueba sirve para:
- Evaluar el **rendimiento** del modelo **con datos nuevos** no utilizados para su entrenamiento.
- Valorar su **capacidad de generalización**, es decir, si ha aprendido patrones en los datos o simplemente ha memorizado los datos introducidos para su entrenamiento.
- Conocer realmente el **rendimiento del modelo**, permitiéndonos compararlo con otros diferentes para poder elegir el más adecuado."""
                    ),
                    style="border: solid 0px grey; border-radius: 10px; background:#eceef1 ;margin-right:50px; padding:15px 20px 10px 20px; text-align: justify; text-justify: inter-word;",
                ),
                selector="#test_split_info",
                where="beforeEnd",
            )
        else:
            ui.update_action_button("show_why_split", label="¿Para qué se realiza la división de los datos? ▽")
            ui.remove_ui("#inserted-why-split-info")