from shiny import module, ui, reactive

@module.ui
def presentation_ui():
    return ui.div(
        {"id": "tool-intro"},
        ui.div(
            ui.markdown("**¡Bienvenido/a a la herramienta interactiva para aprender las técnicas de aprendizaje supervisado aplicadas a ciencias de la salud!** En está página descubrirás cómo se crea un sistema de aprendizaje supervisado desde que se importan los datos hasta que finalmente se utilizan diferentes algoritmos para generar un modelo capaz de predecir resultados de manera satisfactoria. Durante este proceso aprenderás los conceptos básicos para entender cualquier sistema de aprendizaje supervisado o incluso poder crear el tuyo propio."),
            style="padding-right:50px; text-align: justify; text-justify: inter-word;", width=12,
        ),
        ui.input_action_button("show_dataframe_info", "Información sobre la base de datos utilizada ▽"
                                , style="padding: 0px 0px 10px 0px; background: white; border: none; font-weight: bold; text-decoration: underline; border: 0 !important; box-shadow: 0 0 !important; transition: 0.1s !important; background-color: transparent !important;"),
    )


@module.server
def presentation_server(input, output, session):

    @reactive.Effect
    @reactive.event(input.show_dataframe_info)
    def _():
        show_df_info_button = input.show_dataframe_info()
        if show_df_info_button % 2 == 1:
            ui.update_action_button("show_dataframe_info", label="Información sobre la base de datos utilizada △")
            ui.insert_ui(
                ui.div({"id": "inserted-df-info"},
                    ui.markdown("La base de datos seleccionada y que vas a utilizar a partir de ahora es **“Wisconsin breast cancer dataset”**. Es una conocida base de datos de carácter público muy utilizada para ejemplos con algoritmos de aprendizaje supervisado. Consta de 569 entradas (o filas) donde encontramos datos sobre células observadas con el fin de conocer si son malignas o benignas para el diagnóstico de cáncer de mama. La variable que queremos predecir es 'diagnosis', donde conocemos el resultado de las células observadas. El resto de las características se calculan a partir de imágenes digitalizadas de una aspiración con aguja fina (FNA) de una masa en el seno y describen los núcleos celulares presentes en la imagen."),
                    ui.markdown("""**Variables de la base de datos:**
- **id**: el identificador de la muestra observada.
- **diagnosis**: es la variable que queremos predecir, el resultado de las células observadas. M = maligna, B = benigna.
- Las 30 características restantes son datos obtenidos de las las observaciones celulares. Son observaciones de 10 cualidades diferentes de las células, y cada una se evalúa con 3 medidas distintas (sumando 30 en total). Las medidas son la media (mean), el error estándar (se) y el peor o mayor (worst) de dichas cualidades en cada imagen. A continuación, se listan las 10 cualidades:
    - **radius**: radio (media de las distancias desde el centro a puntos en el perímetro)
    - **texture**: textura (desviación estándar de los valores de escala de grises)
    - **perimeter**: perímetro
    - **area**: área
    - **smoothness**: suavidad (variación local en las longitudes del radio)
    - **compactness**: compacidad (perímetro^2 / área - 1.0)
    - **concavity**: concavidad (severidad de las porciones cóncavas del contorno)
    - **concave points**: puntos cóncavos (número de porciones cóncavas del contorno)
    - **symmetry**: simetría
    - **fractal dimension**: dimensión fractal (aproximación de la línea costera - 1)"""
                    ),
                    style="border: solid 0px grey; border-radius: 10px; background:#eceef1 ;margin-right:50px; padding:15px 20px 10px 20px; text-align: justify; text-justify: inter-word;",
                ),
                selector="#tool-intro",
                where="beforeEnd",
            )
        else:
            ui.update_action_button("show_dataframe_info", label="Información sobre la base de datos utilizada ▽")
            ui.remove_ui("#inserted-df-info")