from shiny import module, ui, reactive

@module.ui
def observation_1_ui():
    return ui.div(
        ui.tags.p("Para comprender mejor nuestros datos, podemos realizar operaciones simples con ellos y visualizaciones de diferentes tipos. En esta ocasión es de gran utilidad:"
                   , style="padding-right:50px; padding-top:20px; text-align: justify; text-justify: inter-word;" ),
        ui.div(
            ui.markdown("""- Conocer cuántos casos existen de cada tipo de clase que queremos predecir ('diagnosis'). De esta manera sabremos la **distribución de nuestra base de datos**.
- Separar nuestra base de datos en función la variable a predecir y visualizar los valores que toman el resto de las características por separado. Así podemos **visualizar patrones** que nos ayuden a decidir cuáles serán las características más útiles para la toma de decisiones de nuestros algoritmos."""
            )
            , style="padding-right:50px; padding-bottom:20px; text-align: justify; text-justify: inter-word;" 
        ),
    )


@module.server
def observation_server(input, output, session):
    def _():
        return