from shiny import module, ui, reactive

@module.ui
def correlation_1_ui():
    return ui.div(
        {"id": "correlation-info"},
        ui.tags.h3("CORRELACIÓN DE DATOS"),
        ui.tags.p("La eliminación de características correlacionadas entre sí es otro paso esencial pero que suele ser olvidado. Es importante tener en cuenta que el criterio para eliminar características correlacionadas debe basarse en análisis adecuados y en la comprensión del dominio del problema, para evitar la eliminación de características relevantes para la predicción."
                    , style="padding-right:50px; padding-top:20px; text-align: justify; text-justify: inter-word;"),
        ui.input_action_button("show_corr_benefits", "Beneficios de eliminar variables correlacionadas ▽"
                                , style="padding: 0px 0px 10px 0px; background: white; border: none; font-weight: bold; text-decoration: underline; border: 0 !important; box-shadow: 0 0 !important; transition: 0.1s !important; background-color: transparent !important;"),
    )

@module.ui
def correlation_2_ui():
    return ui.div(
        ui.markdown("Ahora puedes ver la correlación entre todos los datos y eliminar automáticamente las características con una correlación superior a la que marques. Los coeficientes de correlación cuyo **valor absoluto está por encima de 0.7 indican variables que pueden considerarse altamente correlacionadas**. Mi recomendación es eliminarlas automáticamente, pero también puedes eliminar características de forma manual con el selector y el botón del apartado anterior.")
                     , style="padding-right:50px; padding-top:20px; text-align: justify; text-justify: inter-word;"
    )


@module.server
def correlation_server(input, output, session):
    @reactive.Effect
    @reactive.event(input.show_corr_benefits)
    def _():
        show_corr_benef_button = input.show_corr_benefits()
        if show_corr_benef_button % 2 == 1:
            ui.update_action_button("show_corr_benefits", label="Beneficios de eliminar variables correlacionadas △")
            ui.insert_ui(
                ui.div({"id": "inserted-corr-benef-info"},
                    ui.markdown("""La eliminación de variables correlacionadas aporta los siguientes beneficios:
- **Reducción de la redundancia**: Las características correlacionadas proporcionan información redundante o duplicada. Esto aumenta la complejidad del modelo y también puede conducir a un sobreajuste (overfitting), donde el modelo se ajusta demasiado a los datos de entrenamiento y no generaliza bien a nuevos datos.
- **Mejora de la interpretación del modelo**: Un conjunto de características más independientes y distintas mejorará la interpretabilidad del modelo, ya que puede ser difícil discernir la contribución individual de cada una.
- **Eficiencia computacional**: Al eliminar características correlacionadas, se reduce la dimensionalidad del conjunto de datos. Esto mejora la eficiencia computacional durante el entrenamiento y la inferencia del modelo, ya que se reducen los cálculos necesarios y el consumo de recursos.
- **Evitar la multicolinealidad**: La multicolinealidad se refiere a la alta correlación entre dos o más características. Cuando existe multicolinealidad, la matriz de diseño utilizada en algunos algoritmos de aprendizaje puede volverse inestable, lo que afecta la calidad de los resultados."""
                    ),
                    style="border: solid 0px grey; border-radius: 10px; background:#eceef1 ;margin-right:50px; padding:15px 20px 10px 20px; text-align: justify; text-justify: inter-word;",
                ),
                selector="#correlation-info",
                where="beforeEnd",
            )
        else:
            ui.update_action_button("show_corr_benefits", label="Beneficios de eliminar variables correlacionadas ▽")
            ui.remove_ui("#inserted-corr-benef-info")