from shiny import module, ui, reactive

@module.ui
def cleaning_1_ui():
    return ui.div(
        ui.div(
            ui.markdown("La limpieza de la base de datos es uno de los pasos más importantes del proceso de creación de un modelo ya que afectará notablemente a nuestros resultados finales. Debemos asegurarnos de que **no existe ningún dato erróneo, valores nulos o simplemente que no aporte información relevante** para realizar la predicción final. También nos debemos asegurar de que todos los datos se encuentren en el formato correcto para poder ser introducidos a nuestros algoritmos de aprendizaje supervisado.")
            , style="padding-right:50px; padding-top:20px; text-align: justify; text-justify: inter-word;" 
        ),
        ui.tags.p("Esta base de datos requiere únicamente dos cambios:"
                    , style="padding-right:50px; text-align: justify; text-justify: inter-word;"),
        ui.div(
            ui.markdown("- **Modificar los datos de 'diagnosis'**. Muchos algoritmos sólo permiten datos cuantitativos para trabajar. Deberíamos habernos dado cuenta en la tabla de tipos de datos originales que los datos de 'diagnosis' no son cuantitativos, sino que son categóricos (en formato de texto). Por tanto deberemos **convertirla a valores numéricos**, asignando por ejemplo los valores 'B' (benigno) al número 0 y los valores 'M' (maligno) al número 1. ¡Prueba a hacerlo con el botón de abajo!")
            , style="padding-right:50px; text-align: justify; text-justify: inter-word;" 
        ),
    )

@module.ui
def cleaning_2_ui():
    return ui.div(
        ui.div(
            ui.markdown("- También podemos encontrar en nuestra base de datos un **dato claramente irrelevante** para la predicción de 'diagnosis': la columna de 'id'. Únicamente sirve para localizar la muestra fuera del modelo de aprendizaje supervisado. La podemos eliminar con el selector y el botón que encontramos a continuación.")
            , style="padding-right:50px; padding-top:30px; text-align: justify; text-justify: inter-word;" 
        ),
    )

@module.ui
def cleaning_extra_ui():
    return ui.div(
        {"id": "clean-more-info"},
        ui.input_action_button("show_more_cleaning", "Otras operaciones de limpieza ▽"
                                , style="padding: 20px 0px 10px 0px; background: white; border: none; font-weight: bold; text-decoration: underline; border: 0 !important; box-shadow: 0 0 !important; transition: 0.1s !important; background-color: transparent !important;"),
    )


@module.server
def cleaning_server(input, output, session):

    @reactive.Effect
    @reactive.event(input.show_more_cleaning)
    def _():
        show_more_cleaning_button = input.show_more_cleaning()
        if show_more_cleaning_button % 2 == 1:
            ui.update_action_button("show_more_cleaning", label="Otras operaciones de limpieza △")
            ui.insert_ui(
                ui.div({"id": "inserted-clean-info"},
                    ui.markdown("""En otras ocasiones puede ser necesario:
- Eliminar otras columnas con información irrelevante.
- Convertir otras columnas a valores numéricos.
- Eliminar filas con datos erróneos o sin posibilidad de ser tratados correctamente.
- Convertir los datos nulos existentes de columnas o de toda la base de datos a 0.
- Convertir ciertos valores o valores nulos a otro tipo de valor manualmente."""
                    ),
                    style="border: solid 0px grey; border-radius: 10px; background:#eceef1 ;margin-right:50px; padding:15px 20px 10px 20px; text-align: justify; text-justify: inter-word;",
                ),
                selector="#clean-more-info",
                where="beforeEnd",
            )
        else:
            ui.update_action_button("show_more_cleaning", label="Otras operaciones de limpieza ▽")
            ui.remove_ui("#inserted-clean-info")
