__author__ = 'Taneem Jan, taneemishere.github.io'

import gradio as gr
import main_program


# our model's i/o method that take image from gradio interface's inputs.Image()
def model_interface(image):
    return main_model(image)


# main method that call the main_program where code is generated and then compiled
def main_model(input_image):
    result = main_program.main_method(input_image)
    return result


interface_title = "<br> <p style='margin: 0% 8% 0% 8%'>Front end Code Generation with Deep Neural Networks</p>"
interface_description = """<p style='margin: 0% 8% 2% 8%; text-align: justify;text-justify: inter-word;'> Input sketch image and select the framework
and click on submit to generate</p> """

interface_article = """<br><h2 style='text-align: center;'>Creafted with care from Jude</h2> """

interface_examples = ['examples/example-1.png', 'examples/example-2.png', 'examples/example-3.png']

# a gradio interface to convert a image to HTML Code
interface = gr.Interface(
    model_interface,
    inputs='image',
    outputs='text',
    allow_flagging="manual",
    title=interface_title,
    description=interface_description,
    article=interface_article,
    examples=interface_examples
)

interface.launch(share=False)
