import gradio as gr
import yolov5
from PIL import Image
from huggingface_hub import hf_hub_download
import json

title = "Shelf Store Product and Empty spaces on the shelf"
description = "Object detection for products and missing products in a Supermarket shelf"
model_id = 'Jonathancasjar/Retail_Shelves'
article = "<p style='text-align: center'> <a href='https://github.com/Jonathancasjar/Inventory_management_with_object_detection'>Link to repo --> Inventory_management_with_object_detection</a> </p>"

model = yolov5.load(model_id)

examples =[
    ["test_images/Sample_shelf.jpeg",0.25],
    ["test_images/Shelf_image2.jpeg",0.25],
    ["test_images/Shelf_image3.jpeg",0.25],
    ["test_images/Shelf_Example4.jpeg",0.25]
    ]

def predict(imp,threshold=0.25,model_id='Jonathancasjar/Retail_Shelves'):
    #Get model input size
    config_path = hf_hub_download(repo_id=model_id, filename="config.json")
    with open(config_path, "r") as f:
          config = json.load(f)
    input_size = config["input_size"]

    model.conf = threshold
    model_result = model(imp, size=input_size)
    image_tensor = model_result.render()[0]
    output = Image.fromarray(image_tensor)
    return output

demo = gr.Interface(
    title=title,
    description=description,
    article=article,
    analytics_enabled=True,
    allow_flagging='never',
    fn=predict,
    inputs=[
        gr.Image(type='pil'),
        gr.Slider(minimum=0.1,maximum=1.0,value=0.25),
        ],
    outputs=gr.Image(type='pil'),
    examples=examples,        
    cache_examples=True if examples else False)

demo.launch(enable_queue=True)

