import gradio as gr
import re

from transformers import pipeline

sp_model = "JonatanGk/roberta-base-bne-finetuned-cyberbullying-spanish"
ca_model = "JonatanGk/roberta-base-ca-finetuned-cyberbullying-catalan"
sp_analysis = pipeline("text-classification", model=sp_model, tokenizer=sp_model)
ca_analysis = pipeline("text-classification", model=ca_model, tokenizer=ca_model)

def bullying_analysis(language, text):
    if language == 'Spanish':
        results = sp_analysis(text)
    elif language == 'Catalan':
        results = ca_analysis(text)
    return results[0]["label"], round(results[0]["score"], 5)


gradio_ui = gr.Interface(
    fn=bullying_analysis,
    title="CyberBullying Detector (Spanish/Catalan)",
    description="Enter some text and check if model detects bullying.",
    inputs=[
        gr.inputs.Radio(['Spanish','Catalan'],label='Language',),
        gr.inputs.Textbox(lines=5, label="Paste some text here"),
    ],
    outputs=[
        gr.outputs.Textbox(label="Label"),
        gr.outputs.Textbox(label="Score"),
    ],
    examples=[
        ['Spanish', "Eres mas alto que un pino y mas tonto que un pepino!"],
        ['Catalan', "Ets un barrufet!"],
        ['Spanish', "Estas mas gordo que una foca!"],
        ['Catalan', "Ets mes lleig que un pecat!"],
    ],
)

gradio_ui.launch()