import gradio as gr
import re

from transformers import pipeline

sp_model = "JonatanGk/roberta-base-bne-finetuned-catalonia-independence-detector"
ca_model = "JonatanGk/roberta-base-ca-finetuned-catalonia-independence-detector"
sp_analysis = pipeline("text-classification", model=sp_model, tokenizer=sp_model)
ca_analysis = pipeline("text-classification", model=ca_model, tokenizer=ca_model)

def bullying_analysis(language, text):
    if language == 'Spanish':
        results = sp_analysis(text)
    elif language == 'Catalan':
        results = ca_analysis(text)
    return results[0]["label"], round(results[0]["score"], 5)


gradio_ui = gr.Interface(
    fn=bullying_analysis,
    title="Catalonia independence detector (Spanish/Catalan)",
    description="Enter some text and check if model detects is favor/neutral/against Catalonia independence.",
    inputs=[
        gr.inputs.Radio(['Spanish','Catalan'],label='Language',),
        gr.inputs.Textbox(lines=5, label="Paste some text here"),
    ],
    outputs=[
        gr.outputs.Textbox(label="Label"),
        gr.outputs.Textbox(label="Score"),
    ],
    examples=[
        ['Spanish', "Junqueras, sobre la decisión judicial sobre Puigdemont: La justicia que falta en el Estado llega y llegará de Europa"],
        ['Spanish', "Desconvocada la manifestación del domingo en Barcelona en apoyo a Puigdemont"],
        ['Catalan', "Puigdemont, a l'estat espanyol: Quatre anys després, ens hem guanyat el dret a dir prou"],
        ['Catalan', "Llarena demana la detenció de Comín i Ponsatí aprofitant que són a Itàlia amb Puigdemont"],
    ],
)

gradio_ui.launch()