import openai
import gradio
import streamlit as st
import os 
openai.api_key = os.getenv("KEY")

def CustomChatGPT(user_input, AI_Role):

    messages = [{"role": "system",
                 "content": AI_Role}]

    messages.append({"role": "user", "content": user_input})
    response = openai.ChatCompletion.create(
        model = "gpt-3.5-turbo",
        messages = messages
    )
    ChatGPT_reply = response["choices"][0]["message"]["content"]
    messages.append({"role": "assistant", "content": ChatGPT_reply})
    return ChatGPT_reply

demo = gradio.Interface(fn=CustomChatGPT, inputs = ["text", "text"], outputs = "text", title = "ChatGPT Sandbox", description = "Use the prompt to comunicate with ChatGPT and use the AI Role to describe what you want your bots purpose to be. For best results use words like Pretend at the start of the AI_Role. (If AI_Role is left blank it will run on default)", theme = "Soft")

demo.launch() 