import gradio as gr
from fastai.vision.all import *
import skimage

learner = load_learner('export.pkl')

labels = learner.dls.vocab
def predict(img):
  img = PILImage.create(img)
  pred,pred_idx,probs = learner.predict(img)
  return {labels[i]: float(probs[i]) for i in range(len(labels))}


gr.Interface(enable_queue= true,title= "Ivy League Logo/Emblem Classifier",fn=predict, inputs=gr.inputs.Image(shape=(256,256)), outputs=gr.outputs.Label(num_top_classes=3),examples=['img1.jpg','img2.jpg','img3.jpg']).launch()